/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.viz.viewer;

import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.propagation.PointerAnalysis;
import com.ibm.wala.viz.viewer.CgPanel;
import com.ibm.wala.viz.viewer.ChaPanel;
import com.ibm.wala.viz.viewer.PaPanel;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;

public class WalaViewer
extends JFrame {
    protected static final String DefaultMutableTreeNode = null;

    public WalaViewer(CallGraph cg, PointerAnalysis pa) {
        WalaViewer.setNativeLookAndFeel();
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.add("Call Graph", new CgPanel(cg));
        tabbedPane.add("Class Hierarchy", new ChaPanel(cg.getClassHierarchy()));
        PaPanel paPanel = this.createPaPanel(cg, pa);
        paPanel.init();
        tabbedPane.add("Pointer Analysis", paPanel);
        this.setSize(600, 800);
        this.setExtendedState(6);
        this.addWindowListener(new ExitListener());
        this.setTitle("Wala viewer");
        this.add(tabbedPane);
        this.setVisible(true);
    }

    protected PaPanel createPaPanel(CallGraph cg, PointerAnalysis pa) {
        return new PaPanel(cg, pa);
    }

    public static void setNativeLookAndFeel() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static class ExitListener
    extends WindowAdapter {
        private ExitListener() {
        }

        public void windowClosing(WindowEvent event) {
            System.exit(0);
        }
    }
}

