/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.viz.viewer;

import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.PointerKey;
import java.awt.Component;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;

class DualTreeCellRenderer
implements TreeCellRenderer {
    private final DefaultTreeCellRenderer defaultTreeCellRenderer = new DefaultTreeCellRenderer();
    private final DefaultTreeCellRenderer ikTreeCellRenderer = new DefaultTreeCellRenderer();
    private final DefaultTreeCellRenderer pkTreeCellRenderer;

    public DualTreeCellRenderer() {
        this.ikTreeCellRenderer.setOpenIcon(this.createImageIcon("images/ik_open.png"));
        this.ikTreeCellRenderer.setClosedIcon(this.createImageIcon("images/ik_closed.png"));
        this.ikTreeCellRenderer.setLeafIcon(this.createImageIcon("images/ik_leaf.png"));
        this.pkTreeCellRenderer = new DefaultTreeCellRenderer();
        this.pkTreeCellRenderer.setOpenIcon(this.createImageIcon("images/pk_open.png"));
        this.pkTreeCellRenderer.setClosedIcon(this.createImageIcon("images/pk_closed.png"));
        this.pkTreeCellRenderer.setLeafIcon(this.createImageIcon("images/pk_leaf.png"));
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        TreeCellRenderer delegate = this.getTreeCellRenderer(value);
        return delegate.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
    }

    private TreeCellRenderer getTreeCellRenderer(Object value) {
        if (value instanceof DefaultMutableTreeNode) {
            value = ((DefaultMutableTreeNode)value).getUserObject();
        }
        if (value instanceof PointerKey) {
            return this.pkTreeCellRenderer;
        }
        if (value instanceof InstanceKey) {
            return this.ikTreeCellRenderer;
        }
        return this.defaultTreeCellRenderer;
    }

    protected ImageIcon createImageIcon(String path) {
        URL imgURL = DualTreeCellRenderer.class.getResource(path);
        if (imgURL != null) {
            return new ImageIcon(imgURL);
        }
        System.err.println("Couldn't find file: " + path);
        return null;
    }
}

