/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.viz.viewer;

import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.viz.viewer.IrAndSourceViewer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class CgPanel
extends JSplitPane {
    private final CallGraph cg;

    public CgPanel(CallGraph cg) {
        this.cg = cg;
        this.setDividerLocation(250);
        JTree tree = this.buildTree();
        this.setLeftComponent(new JScrollPane(tree));
        final IrAndSourceViewer irViewer = new IrAndSourceViewer(cg);
        this.setRightComponent(irViewer.getComponent());
        tree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                TreePath newLeadSelectionPath = e.getNewLeadSelectionPath();
                if (newLeadSelectionPath == null) {
                    return;
                }
                DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)newLeadSelectionPath.getLastPathComponent();
                Object userObject = treeNode.getUserObject();
                if (userObject instanceof CGNode) {
                    CGNode node = (CGNode)userObject;
                    IR ir = node.getIR();
                    irViewer.setIR(ir);
                } else if (userObject instanceof CallSiteReference) {
                    CGNode parentNode = (CGNode)((DefaultMutableTreeNode)treeNode.getParent()).getUserObject();
                    IR ir = parentNode.getIR();
                    irViewer.setIRAndPc(ir, ((CallSiteReference)userObject).getProgramCounter());
                }
            }
        });
    }

    private JTree buildTree() {
        CGNode cgRoot = this.cg.getFakeRootNode();
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(cgRoot);
        this.expandNode(root);
        JTree tree = new JTree(root);
        tree.addTreeExpansionListener(new TreeExpansionListener(){

            public void treeExpanded(TreeExpansionEvent event) {
                TreePath path = event.getPath();
                if (path == null) {
                    return;
                }
                DefaultMutableTreeNode lastNode = (DefaultMutableTreeNode)path.getLastPathComponent();
                CgPanel.this.expandNode(lastNode);
            }

            public void treeCollapsed(TreeExpansionEvent event) {
            }
        });
        return tree;
    }

    private void expandNode(DefaultMutableTreeNode treeNode) {
        this.expandNode(treeNode, 3);
    }

    private void expandNode(DefaultMutableTreeNode treeNode, int rec) {
        if (rec == 0) {
            return;
        }
        if (treeNode.getChildCount() == 0) {
            ArrayList<DefaultMutableTreeNode> newChilds = new ArrayList<DefaultMutableTreeNode>();
            Object userObject = treeNode.getUserObject();
            if (userObject instanceof CGNode) {
                CGNode cgNode = (CGNode)userObject;
                Iterator<CallSiteReference> iter = cgNode.iterateCallSites();
                while (iter.hasNext()) {
                    CallSiteReference csr = iter.next();
                    newChilds.add(new DefaultMutableTreeNode(csr));
                }
            } else {
                assert (userObject instanceof CallSiteReference);
                CallSiteReference csr = (CallSiteReference)userObject;
                CGNode cgNode = (CGNode)((DefaultMutableTreeNode)treeNode.getParent()).getUserObject();
                Set<CGNode> successors = this.cg.getPossibleTargets(cgNode, csr);
                for (CGNode successor : successors) {
                    newChilds.add(new DefaultMutableTreeNode(successor));
                }
            }
            for (DefaultMutableTreeNode newChild : newChilds) {
                treeNode.add(newChild);
            }
        }
        int i = 0;
        while (i < treeNode.getChildCount()) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)treeNode.getChildAt(i);
            this.expandNode(child, rec - 1);
            ++i;
        }
    }
}

