/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.viz;

import com.ibm.wala.cfg.CFGSanitizer;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.ISSABasicBlock;
import com.ibm.wala.ssa.SSACFG;
import com.ibm.wala.ssa.SSAGetCaughtExceptionInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAPhiInstruction;
import com.ibm.wala.ssa.SSAPiInstruction;
import com.ibm.wala.util.WalaException;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.graph.Graph;
import com.ibm.wala.util.strings.StringStuff;
import com.ibm.wala.viz.DotUtil;
import com.ibm.wala.viz.NodeDecorator;
import com.ibm.wala.viz.PDFViewLauncher;
import java.util.HashMap;
import java.util.Iterator;

public class PDFViewUtil {
    public static Process ghostviewIR(IClassHierarchy cha, IR ir, String pdfFile, String dotFile, String dotExe, String pdfViewExe) throws WalaException {
        return PDFViewUtil.ghostviewIR(cha, ir, pdfFile, dotFile, dotExe, pdfViewExe, null);
    }

    public static Process ghostviewIR(IClassHierarchy cha, IR ir, String pdfFile, String dotFile, String dotExe, String pdfViewExe, NodeDecorator annotations) throws WalaException {
        if (ir == null) {
            throw new IllegalArgumentException("ir is null");
        }
        Graph<ISSABasicBlock> g = ir.getControlFlowGraph();
        NodeDecorator labels = PDFViewUtil.makeIRDecorator(ir);
        if (annotations != null) {
            labels = new ConcatenatingNodeDecorator(annotations, labels);
        }
        g = CFGSanitizer.sanitize(ir, cha);
        DotUtil.dotify(g, labels, dotFile, pdfFile, dotExe);
        return PDFViewUtil.launchPDFView(pdfFile, pdfViewExe);
    }

    public static NodeDecorator makeIRDecorator(IR ir) {
        if (ir == null) {
            throw new IllegalArgumentException("ir is null");
        }
        final HashMap<SSACFG.BasicBlock, String> labelMap = HashMapFactory.make();
        for (SSACFG.BasicBlock bb : ir.getControlFlowGraph()) {
            labelMap.put(bb, PDFViewUtil.getNodeLabel(ir, bb));
        }
        NodeDecorator labels = new NodeDecorator(){

            public String getLabel(Object o) {
                return (String)labelMap.get(o);
            }
        };
        return labels;
    }

    private static String getNodeLabel(IR ir, SSACFG.BasicBlock bb) {
        StringBuffer result = new StringBuffer();
        int start = bb.getFirstInstructionIndex();
        int end = bb.getLastInstructionIndex();
        result.append("BB").append(bb.getNumber());
        if (bb.isEntryBlock()) {
            result.append(" (en)\\n");
        } else if (bb.isExitBlock()) {
            result.append(" (ex)\\n");
        }
        if (bb instanceof SSACFG.ExceptionHandlerBasicBlock) {
            result.append("<Handler>");
        }
        result.append("\\n");
        Iterator<SSAPhiInstruction> it = bb.iteratePhis();
        while (it.hasNext()) {
            SSAPhiInstruction phi = it.next();
            if (phi == null) continue;
            result.append("           " + phi.toString(ir.getSymbolTable())).append("\\l");
        }
        if (bb instanceof SSACFG.ExceptionHandlerBasicBlock) {
            SSACFG.ExceptionHandlerBasicBlock ebb = (SSACFG.ExceptionHandlerBasicBlock)bb;
            SSAGetCaughtExceptionInstruction s = ebb.getCatchInstruction();
            if (s != null) {
                result.append("           " + s.toString(ir.getSymbolTable())).append("\\l");
            } else {
                result.append("            No catch instruction. Unreachable?\\l");
            }
        }
        SSAInstruction[] instructions = ir.getInstructions();
        int j = start;
        while (j <= end) {
            if (instructions[j] != null) {
                StringBuffer x = new StringBuffer(String.valueOf(j) + "   " + instructions[j].toString(ir.getSymbolTable()));
                StringStuff.padWithSpaces(x, 35);
                result.append(x);
                result.append("\\l");
            }
            ++j;
        }
        Iterator<SSAPiInstruction> it2 = bb.iteratePis();
        while (it2.hasNext()) {
            SSAPiInstruction pi = it2.next();
            if (pi == null) continue;
            result.append("           " + pi.toString(ir.getSymbolTable())).append("\\l");
        }
        return result.toString();
    }

    public static Process launchPDFView(String pdfFile, String gvExe) throws WalaException {
        if (gvExe == null) {
            throw new IllegalArgumentException("null gvExe");
        }
        if (pdfFile == null) {
            throw new IllegalArgumentException("null psFile");
        }
        PDFViewLauncher gv = new PDFViewLauncher();
        gv.setGvExe(gvExe);
        gv.setPDFFile(pdfFile);
        gv.run();
        if (gv.getProcess() == null) {
            throw new WalaException(" problem spawning process ");
        }
        return gv.getProcess();
    }

    private static final class ConcatenatingNodeDecorator
    implements NodeDecorator {
        private final NodeDecorator A;
        private final NodeDecorator B;

        ConcatenatingNodeDecorator(NodeDecorator A2, NodeDecorator B2) {
            this.A = A2;
            this.B = B2;
        }

        public String getLabel(Object o) throws WalaException {
            return String.valueOf(this.A.getLabel(o)) + this.B.getLabel(o);
        }
    }
}

