/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.tables;

import com.ibm.wala.util.collections.SimpleVector;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.tables.Table;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.StringTokenizer;

public class StringTable
extends Table<String>
implements Cloneable {
    public StringTable() {
    }

    public StringTable(StringTable t) {
        super(t);
    }

    public StringTable(String[] columns) {
        super(columns);
    }

    public static StringTable readFromDirectTextFile(String fileName, Character comment) throws FileNotFoundException, IOException {
        if (fileName == null) {
            throw new IllegalArgumentException("fileName is null");
        }
        File f = new File(fileName);
        return StringTable.readFromTextFile(f, comment);
    }

    public static StringTable readFromTextFile(File f, Character comment) throws FileNotFoundException, IOException {
        if (f == null) {
            throw new IllegalArgumentException("null f");
        }
        return StringTable.readFromStream(new FileInputStream(f), comment);
    }

    public static StringTable readFromStream(InputStream s, Character commentToken) throws IOException {
        return StringTable.readFromStream(s, commentToken, null);
    }

    public static StringTable readFromStream(InputStream s, Character commentToken, Character delimiter) throws IOException {
        if (s == null) {
            throw new IllegalArgumentException("s is null");
        }
        StringTable result = new StringTable();
        LineNumberReader reader = new LineNumberReader(new InputStreamReader(s));
        String line = StringTable.readNextNonCommentLine(reader, commentToken);
        if (line == null) {
            throw new IOException("first line expected to be column headings");
        }
        result.populateColumnHeadings(line, delimiter);
        line = StringTable.readNextNonCommentLine(reader, commentToken);
        int row = 0;
        while (line != null) {
            result.populateRow(row, line, delimiter);
            line = StringTable.readNextNonCommentLine(reader, commentToken);
            ++row;
        }
        return result;
    }

    public static String readNextNonCommentLine(LineNumberReader reader, Character commentToken) throws IOException {
        if (reader == null) {
            throw new IllegalArgumentException("reader is null");
        }
        String line = reader.readLine();
        while (line != null && StringTable.isCommented(line, commentToken)) {
            line = reader.readLine();
        }
        return line;
    }

    private static boolean isCommented(String line, Character commentToken) {
        if (line.length() == 0) {
            return true;
        }
        if (commentToken == null) {
            return false;
        }
        return line.charAt(0) == commentToken.charValue();
    }

    private void populateRow(int row, String line, Character delimiter) {
        StringTokenizer st = delimiter == null ? new StringTokenizer(line) : new StringTokenizer(line, delimiter.toString());
        int nColumns = st.countTokens();
        Assertions.productionAssertion(nColumns == this.getNumberOfColumns(), "expected " + this.getNumberOfColumns() + " got " + nColumns + " row " + row + " " + line.length() + " " + line);
        SimpleVector<String> r = new SimpleVector<String>();
        this.rows.add(row, r);
        int i = 0;
        while (i < nColumns) {
            r.set(i, (String)st.nextElement());
            ++i;
        }
    }

    private void populateColumnHeadings(String line, Character delimiter) {
        StringTokenizer st = delimiter == null ? new StringTokenizer(line) : new StringTokenizer(line, delimiter.toString());
        int nColumns = st.countTokens();
        int i = 0;
        while (i < nColumns) {
            this.columnHeadings.set(i, (String)st.nextElement());
            ++i;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        StringTable result = new StringTable(this);
        int i = 0;
        while (i < this.getNumberOfRows()) {
            result.addRow(this.row2Map(i));
            ++i;
        }
        return result;
    }
}

