/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.strings;

import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.strings.ImmutableByteArray;
import com.ibm.wala.util.strings.UTF8Convert;
import java.io.Serializable;
import java.io.UTFDataFormatException;
import java.util.HashMap;

public final class Atom
implements Serializable {
    private static final long serialVersionUID = -3256390509887654329L;
    private static final HashMap<AtomKey, Atom> dictionary = HashMapFactory.make();
    private final byte[] val;
    private final int hash;

    public static Atom findOrCreateUnicodeAtom(String str) {
        byte[] utf8 = UTF8Convert.toUTF8(str);
        return Atom.findOrCreate(utf8);
    }

    public static Atom findOrCreateAsciiAtom(String str) {
        if (str == null) {
            throw new IllegalArgumentException("str is null");
        }
        byte[] ascii = str.getBytes();
        return Atom.findOrCreate(ascii);
    }

    public static Atom findOrCreateUtf8Atom(byte[] utf8) {
        if (utf8 == null) {
            throw new IllegalArgumentException("utf8 is null");
        }
        return Atom.findOrCreate(utf8);
    }

    public static Atom findOrCreate(byte[] utf8, int off, int len) throws IllegalArgumentException, IllegalArgumentException, IllegalArgumentException {
        if (utf8 == null) {
            throw new IllegalArgumentException("utf8 == null");
        }
        if (len < 0) {
            throw new IllegalArgumentException("len must be >= 0, " + len);
        }
        if (off < 0) {
            throw new IllegalArgumentException("off must be >= 0, " + off);
        }
        if (utf8.length < off + len) {
            throw new IllegalArgumentException("utf8.length < off + len");
        }
        if (off + len < 0) {
            throw new IllegalArgumentException("off + len is too big: " + off + " + " + len);
        }
        byte[] val = new byte[len];
        int i = 0;
        while (i < len) {
            val[i] = utf8[off++];
            ++i;
        }
        return Atom.findOrCreate(val);
    }

    public static synchronized Atom findOrCreate(byte[] bytes) {
        if (bytes == null) {
            throw new IllegalArgumentException("bytes is null");
        }
        AtomKey key = new AtomKey(bytes);
        Atom val = dictionary.get(key);
        if (val != null) {
            return val;
        }
        val = new Atom(key);
        dictionary.put(key, val);
        return val;
    }

    public static synchronized Atom findOrCreate(ImmutableByteArray b) {
        if (b == null) {
            throw new IllegalArgumentException("b is null");
        }
        return Atom.findOrCreate(b.b);
    }

    public static synchronized Atom findOrCreate(ImmutableByteArray b, int start, int length) {
        if (b == null) {
            throw new IllegalArgumentException("b is null");
        }
        return Atom.findOrCreate(b.b, start, length);
    }

    public final String toString() {
        return new String(this.val);
    }

    public final String toUnicodeString() throws UTFDataFormatException {
        return UTF8Convert.fromUTF8(this.val);
    }

    public final Atom arrayDescriptorFromElementDescriptor() {
        byte[] sig = new byte[1 + this.val.length];
        sig[0] = 91;
        int i = 0;
        int n = this.val.length;
        while (i < n) {
            sig[i + 1] = this.val[i];
            ++i;
        }
        return Atom.findOrCreate(sig);
    }

    public final boolean isReservedMemberName() {
        if (this.length() == 0) {
            return false;
        }
        return this.val[0] == 60;
    }

    public final boolean isClassDescriptor() {
        if (this.length() == 0) {
            return false;
        }
        return this.val[0] == 76;
    }

    public final boolean isArrayDescriptor() {
        if (this.length() == 0) {
            return false;
        }
        return this.val[0] == 91;
    }

    public final boolean isMethodDescriptor() throws IllegalArgumentException {
        if (this.length() == 0) {
            return false;
        }
        return this.val[0] == 40;
    }

    public final int length() {
        return this.val.length;
    }

    private Atom(AtomKey key) {
        this.val = key.val;
        this.hash = key.hash;
    }

    public final Atom parseForArrayElementDescriptor() throws IllegalArgumentException {
        if (this.val.length == 0) {
            throw new IllegalArgumentException("empty atom is not an array");
        }
        return Atom.findOrCreate(this.val, 1, this.val.length - 1);
    }

    public final int parseForArrayDimensionality() throws IllegalArgumentException {
        if (this.val.length == 0) {
            throw new IllegalArgumentException("empty atom is not an array");
        }
        try {
            int i = 0;
            while (true) {
                if (this.val[i] != 91) {
                    return i;
                }
                ++i;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalStateException("not an array: " + this);
        }
    }

    public final Atom parseForInnermostArrayElementDescriptor() throws IllegalArgumentException {
        if (this.val.length == 0) {
            throw new IllegalArgumentException("empty atom is not an array");
        }
        try {
            int i = 0;
            while (this.val[i] == 91) {
                ++i;
            }
            return Atom.findOrCreate(this.val, i, this.val.length - i);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalStateException("not an array: " + this);
        }
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object obj) {
        return this == obj;
    }

    public byte[] getValArray() {
        byte[] result = new byte[this.val.length];
        System.arraycopy(this.val, 0, result, 0, this.val.length);
        return result;
    }

    public byte getVal(int i) throws IllegalArgumentException {
        try {
            return this.val[i];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Illegal index: " + i + " length is " + this.val.length);
        }
    }

    public boolean contains(byte b) {
        int i = 0;
        while (i < this.val.length) {
            if (this.val[i] == b) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static Atom concat(byte c, byte[] bs) {
        byte[] val = new byte[bs.length + 1];
        val[0] = c;
        System.arraycopy(bs, 0, val, 1, bs.length);
        return Atom.findOrCreate(val);
    }

    public static Atom concat(byte c, ImmutableByteArray b) {
        if (b == null) {
            throw new IllegalArgumentException("b is null");
        }
        return Atom.concat(c, b.b);
    }

    public static boolean isArrayDescriptor(ImmutableByteArray b) {
        if (b == null) {
            throw new IllegalArgumentException("b is null");
        }
        if (b.length() == 0) {
            return false;
        }
        return b.get(0) == 91;
    }

    private Object readResolve() {
        return Atom.findOrCreate(this.val);
    }

    private static final class AtomKey {
        private final byte[] val;
        private final int hash;

        private AtomKey(byte[] utf8) {
            int tmp = 99989;
            int i = utf8.length;
            while (--i >= 0) {
                tmp = 99991 * tmp + utf8[i];
            }
            this.val = utf8;
            this.hash = tmp;
        }

        public final boolean equals(Object other) {
            assert (other != null && this.getClass().equals(other.getClass()));
            if (this == other) {
                return true;
            }
            AtomKey that = (AtomKey)other;
            if (this.hash != that.hash) {
                return false;
            }
            if (this.val.length != that.val.length) {
                return false;
            }
            int i = 0;
            while (i < this.val.length) {
                if (this.val[i] != that.val[i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        public final String toString() {
            return new String(this.val);
        }

        public final int hashCode() {
            return this.hash;
        }
    }
}

