/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.processes;

import com.ibm.wala.util.PlatformUtil;
import com.ibm.wala.util.processes.Launcher;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;

public class JavaLauncher
extends Launcher {
    private String programArgs;
    private final String mainClass;
    private final boolean inheritClasspath;
    private boolean enableAssertions;
    private final List<String> xtraClasspath = new ArrayList<String>();
    private Thread stdOutDrain;
    private Thread stdErrDrain;
    private String javaExe;
    private String vmArgs;
    private Process lastProcess;

    public static JavaLauncher make(String programArgs, String mainClass, List<String> classpathEntries, Logger logger) {
        return new JavaLauncher(programArgs, mainClass, true, classpathEntries, false, false, logger);
    }

    public static JavaLauncher make(String programArgs, String mainClass, boolean inheritClasspath, List<String> classpathEntries, boolean captureOutput, boolean captureErr, Logger logger) {
        if (mainClass == null) {
            throw new IllegalArgumentException("null mainClass");
        }
        return new JavaLauncher(programArgs, mainClass, inheritClasspath, classpathEntries, captureOutput, captureErr, logger);
    }

    private JavaLauncher(String programArgs, String mainClass, boolean inheritClasspath, List<String> xtraClasspath, boolean captureOutput, boolean captureErr, Logger logger) {
        super(captureOutput, captureErr, logger);
        this.programArgs = programArgs;
        this.mainClass = mainClass;
        this.inheritClasspath = inheritClasspath;
        if (xtraClasspath != null) {
            this.xtraClasspath.addAll(xtraClasspath);
        }
        this.javaExe = JavaLauncher.defaultJavaExe();
    }

    public String getJavaExe() {
        return this.javaExe;
    }

    public void setJavaExe(String javaExe) {
        this.javaExe = javaExe;
    }

    public void setProgramArgs(String s) {
        this.programArgs = s;
    }

    public String getProgramArgs() {
        return this.programArgs;
    }

    public String getMainClass() {
        return this.mainClass;
    }

    public List<String> getXtraClassPath() {
        return this.xtraClasspath;
    }

    @Override
    public String toString() {
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (programArgs: ");
        result.append(this.programArgs);
        result.append(", mainClass: ");
        result.append(this.mainClass);
        result.append(", xtraClasspath: ");
        result.append(this.xtraClasspath);
        result.append(')');
        return result.toString();
    }

    public static String defaultJavaExe() {
        String java = String.valueOf(System.getProperty("java.home")) + File.separatorChar + "bin" + File.separatorChar + "java";
        return java;
    }

    public Process start() throws IllegalArgumentException, IOException {
        String cp = this.makeClasspath();
        String heap = " -Xmx800M ";
        String signalParam = PlatformUtil.onMacOSX() ? " -Xrs " : "";
        String ea = this.enableAssertions ? " -ea " : "";
        String vmArgs = this.getVmArgs() == null ? "" : this.getVmArgs();
        String cmd = String.valueOf(this.javaExe) + heap + signalParam + cp + " " + this.makeLibPath() + " " + ea + " " + vmArgs + " " + this.getMainClass() + " " + this.getProgramArgs();
        Process p = this.spawnProcess(cmd);
        this.stdErrDrain = this.isCaptureErr() ? this.captureStdErr(p) : this.drainStdErr(p);
        this.stdOutDrain = this.isCaptureOutput() ? this.captureStdOut(p) : this.drainStdOut(p);
        this.lastProcess = p;
        return p;
    }

    public Process getLastProcess() {
        return this.lastProcess;
    }

    private String makeLibPath() {
        String libPath = System.getProperty("java.library.path");
        if (libPath == null) {
            return "";
        }
        return "-Djava.library.path=" + JavaLauncher.quoteStringIfNeeded(libPath);
    }

    public void join() {
        Launcher.Drainer d;
        if (this.stdOutDrain == null || this.stdErrDrain == null) {
            throw new IllegalStateException("process not started.  illegal to join()");
        }
        try {
            this.stdOutDrain.join();
            this.stdErrDrain.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            throw new InternalError("Internal error in JavaLauncher.join()");
        }
        if (this.isCaptureErr()) {
            d = (Launcher.Drainer)this.stdErrDrain;
            this.setStdErr(d.getCapture().toByteArray());
        }
        if (this.isCaptureOutput()) {
            d = (Launcher.Drainer)this.stdOutDrain;
            this.setStdOut(d.getCapture().toByteArray());
        }
    }

    private String makeClasspath() {
        String cp;
        String string = cp = this.inheritClasspath ? System.getProperty("java.class.path") : "";
        if (this.getXtraClassPath() == null || this.getXtraClassPath().isEmpty()) {
            return " -classpath " + JavaLauncher.quoteStringIfNeeded(cp);
        }
        Iterator<String> it = this.getXtraClassPath().iterator();
        while (it.hasNext()) {
            cp = String.valueOf(cp) + File.pathSeparatorChar;
            cp = String.valueOf(cp) + it.next();
        }
        return " -classpath " + JavaLauncher.quoteStringIfNeeded(cp);
    }

    public static String quoteStringIfNeeded(String s) {
        if ((s = s.trim()).indexOf(32) == -1) {
            return s;
        }
        if (s.charAt(s.length() - 1) == '\\' && s.charAt(s.length() - 2) != '\\') {
            s = String.valueOf(s) + '\\';
        }
        return String.valueOf('\"') + s + '\"';
    }

    public boolean isEnableAssertions() {
        return this.enableAssertions;
    }

    public void setEnableAssertions(boolean enableAssertions) {
        this.enableAssertions = enableAssertions;
    }

    public void setVmArgs(String vmArgs) {
        this.vmArgs = vmArgs;
    }

    public String getVmArgs() {
        return this.vmArgs;
    }
}

