/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.perf;

import com.ibm.wala.util.perf.Stopwatch;

public class StopwatchGC
extends Stopwatch {
    private final String name;
    private long startMemory;
    private long endMemory;

    public StopwatchGC(String name) {
        this.name = name;
    }

    @Override
    public final void start() {
        if (this.count == 0) {
            System.gc();
            Runtime r = Runtime.getRuntime();
            this.startMemory = r.totalMemory() - r.freeMemory();
        }
        super.start();
    }

    @Override
    public final void stop() {
        super.stop();
        System.gc();
        Runtime r = Runtime.getRuntime();
        this.endMemory = r.totalMemory() - r.freeMemory();
    }

    public final String report() {
        String result = "";
        if (this.getCount() > 0) {
            result = String.valueOf(result) + "Stopwatch: " + this.name + " " + this.getElapsedMillis() + " ms" + "\n";
        }
        if (this.getCount() == 1) {
            result = String.valueOf(result) + "       Footprint at entry: " + (float)this.startMemory / 1000000.0f + " MB\n";
            result = String.valueOf(result) + "        Footprint at exit: " + (float)this.endMemory / 1000000.0f + " MB\n";
            result = String.valueOf(result) + "                    Delta: " + (float)(this.endMemory - this.startMemory) / 1000000.0f + " MB\n";
        }
        return result;
    }

    public float getEndMemory() {
        return (float)this.endMemory / 1000000.0f;
    }

    public float getStartMemory() {
        return (float)this.startMemory / 1000000.0f;
    }

    public float getFootprint() {
        return this.getEndMemory() - this.getStartMemory();
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(super.toString());
        sb.append(", Delta: " + (float)(this.endMemory - this.startMemory) / 1000000.0f + " MB");
        return sb.toString();
    }
}

