/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.intset;

import com.ibm.wala.util.collections.EmptyIterator;
import com.ibm.wala.util.collections.Iterator2Collection;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.intset.IntIterator;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.MutableSparseIntSet;
import com.ibm.wala.util.intset.OrdinalSetMapping;
import com.ibm.wala.util.intset.SparseIntSet;
import java.util.Collection;
import java.util.Iterator;

public class OrdinalSet<T>
implements Iterable<T> {
    private final IntSet S;
    private final OrdinalSetMapping<T> mapping;
    private static final OrdinalSet EMPTY = new OrdinalSet();

    public static <T> OrdinalSet<T> empty() {
        return EMPTY;
    }

    private OrdinalSet() {
        this.S = null;
        this.mapping = null;
    }

    public OrdinalSet(IntSet S, OrdinalSetMapping<T> mapping) {
        this.S = S;
        this.mapping = mapping;
    }

    public boolean containsAny(OrdinalSet<T> that) {
        if (that == null) {
            throw new IllegalArgumentException("null that");
        }
        if (this.S == null || that.S == null) {
            return false;
        }
        return this.S.containsAny(that.S);
    }

    public int size() {
        return this.S == null ? 0 : this.S.size();
    }

    @Override
    public Iterator<T> iterator() {
        if (this.S == null) {
            return EmptyIterator.instance();
        }
        return new Iterator<T>(){
            IntIterator it;
            {
                this.it = OrdinalSet.this.S.intIterator();
            }

            @Override
            public boolean hasNext() {
                return this.it.hasNext();
            }

            @Override
            public T next() {
                return OrdinalSet.this.mapping.getMappedObject(this.it.next());
            }

            @Override
            public void remove() {
                Assertions.UNREACHABLE();
            }
        };
    }

    public static <T> OrdinalSet<T> intersect(OrdinalSet<T> A2, OrdinalSet<T> B2) {
        if (A2 == null) {
            throw new IllegalArgumentException("A is null");
        }
        if (A2.size() != 0 && B2.size() != 0) assert (A2.mapping.equals(B2.mapping));
        if (A2.S == null || B2.S == null) {
            return new OrdinalSet<T>(null, A2.mapping);
        }
        IntSet isect = A2.S.intersection(B2.S);
        return new OrdinalSet<T>(isect, A2.mapping);
    }

    public static <T> OrdinalSet<T> unify(OrdinalSet<T> A2, OrdinalSet<T> B2) {
        if (A2 == null) {
            throw new IllegalArgumentException("A is null");
        }
        if (B2 == null) {
            throw new IllegalArgumentException("B is null");
        }
        if (A2.size() != 0 && B2.size() != 0) assert (A2.mapping.equals(B2.mapping));
        if (A2.S == null) {
            return B2.S == null ? OrdinalSet.empty() : new OrdinalSet<T>(B2.S, B2.mapping);
        }
        if (B2.S == null) {
            return new OrdinalSet<T>(A2.S, A2.mapping);
        }
        IntSet union = A2.S.union(B2.S);
        return new OrdinalSet<T>(union, A2.mapping);
    }

    public String toString() {
        return Iterator2Collection.toSet(this.iterator()).toString();
    }

    public SparseIntSet makeSparseCopy() {
        return this.S == null ? new SparseIntSet() : new SparseIntSet(this.S);
    }

    public IntSet getBackingSet() {
        return this.S;
    }

    public boolean contains(T object) {
        if (this == EMPTY || this.S == null || object == null) {
            return false;
        }
        int index = this.mapping.getMappedIndex(object);
        return index == -1 ? false : this.S.contains(index);
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public static <T> Collection<T> toCollection(OrdinalSet<T> instances) {
        return Iterator2Collection.toSet(instances.iterator());
    }

    public static <T> OrdinalSet<T> toOrdinalSet(Collection<T> c, OrdinalSetMapping<T> m) {
        if (c == null) {
            throw new IllegalArgumentException("c is null");
        }
        if (m == null) {
            throw new IllegalArgumentException("m is null");
        }
        MutableSparseIntSet s = MutableSparseIntSet.makeEmpty();
        Iterator<T> it = c.iterator();
        while (it.hasNext()) {
            int index = m.getMappedIndex(it.next());
            assert (index >= 0);
            s.add(index);
        }
        return new OrdinalSet<T>(s, m);
    }

    public OrdinalSetMapping<T> getMapping() {
        return this.mapping;
    }
}

