/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.intset;

import com.ibm.wala.util.intset.LongSet;
import com.ibm.wala.util.intset.MutableLongSet;
import com.ibm.wala.util.intset.MutableLongSetFactory;
import com.ibm.wala.util.intset.MutableSparseLongSet;
import com.ibm.wala.util.intset.SparseIntSet;
import java.util.TreeSet;

public class MutableSparseLongSetFactory
implements MutableLongSetFactory {
    @Override
    public MutableLongSet make(long[] set) {
        if (set == null) {
            throw new IllegalArgumentException("set is null");
        }
        if (set.length == 0) {
            return new MutableSparseLongSet();
        }
        TreeSet<Long> T = new TreeSet<Long>();
        int i = 0;
        while (i < set.length) {
            T.add(set[i]);
            ++i;
        }
        long[] copy = new long[T.size()];
        int i2 = 0;
        for (Long I : T) {
            copy[i2++] = I;
        }
        MutableSparseLongSet result = new MutableSparseLongSet(copy);
        return result;
    }

    @Override
    public MutableLongSet parse(String string) throws NumberFormatException {
        int[] backingStore = SparseIntSet.parseIntArray(string);
        long[] bs = new long[backingStore.length];
        int i = 0;
        while (i < bs.length) {
            bs[i] = backingStore[i];
            ++i;
        }
        return new MutableSparseLongSet(bs);
    }

    @Override
    public MutableLongSet makeCopy(LongSet x) throws IllegalArgumentException {
        if (x == null) {
            throw new IllegalArgumentException("x == null");
        }
        return MutableSparseLongSet.make(x);
    }

    @Override
    public MutableLongSet make() {
        return new MutableSparseLongSet();
    }
}

