/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.intset;

public class IntegerUnionFind {
    private static final int MAX_VALUE = 0x1FFFFFFF;
    private static final int DEFAULT_SIZE = 100;
    int[] parent;

    public IntegerUnionFind() {
        this(100);
    }

    public IntegerUnionFind(int size) {
        if (size < 0 || size > 0x1FFFFFFF) {
            throw new IllegalArgumentException("illegal size: " + size);
        }
        this.parent = new int[size + 1];
    }

    public void union(int x, int y) {
        if (x < 0) {
            throw new IllegalArgumentException("invalid x : " + x);
        }
        if (y < 0) {
            throw new IllegalArgumentException("invalid y: " + y);
        }
        if (x > 0x1FFFFFFF) {
            throw new IllegalArgumentException("x is too big: " + x);
        }
        if (y > 0x1FFFFFFF) {
            throw new IllegalArgumentException("y is too big: " + y);
        }
        if (x >= this.size() || y >= this.size()) {
            this.grow(2 * Math.max(x, y));
        }
        ++x;
        ++y;
        if ((x = this.findInternal(x)) != (y = this.findInternal(y))) {
            if (this.parent[x] < this.parent[y]) {
                int n = x;
                this.parent[n] = this.parent[n] + (this.parent[y] - 1);
                this.parent[y] = x;
            } else {
                int n = y;
                this.parent[n] = this.parent[n] + (this.parent[x] - 1);
                this.parent[x] = y;
            }
        }
    }

    private void grow(int size) {
        int[] old = this.parent;
        this.parent = new int[size + 1];
        System.arraycopy(old, 0, this.parent, 0, old.length);
    }

    public int find(int x) {
        if (x < 0) {
            throw new IllegalArgumentException("illegal x " + x);
        }
        if (x >= this.size()) {
            return x;
        }
        return this.findInternal(x + 1) - 1;
    }

    private int findInternal(int x) {
        int root = x;
        while (this.parent[root] > 0) {
            root = this.parent[root];
        }
        while (this.parent[x] > 0) {
            int z = x;
            x = this.parent[x];
            this.parent[z] = root;
        }
        return root;
    }

    public int size() {
        return this.parent.length - 1;
    }
}

