/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.intset;

import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.debug.UnimplementedError;
import com.ibm.wala.util.intset.BimodalMutableIntSet;
import com.ibm.wala.util.intset.BitVectorIntSet;
import com.ibm.wala.util.intset.DebuggingMutableIntSet;
import com.ibm.wala.util.intset.EmptyIntSet;
import com.ibm.wala.util.intset.IntIterator;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.MutableIntSet;
import com.ibm.wala.util.intset.MutableIntSetFactory;
import com.ibm.wala.util.intset.MutableSharedBitVectorIntSet;
import com.ibm.wala.util.intset.MutableSharedBitVectorIntSetFactory;
import com.ibm.wala.util.intset.MutableSparseIntSet;
import com.ibm.wala.util.intset.SemiSparseMutableIntSet;
import com.ibm.wala.util.intset.SparseIntSet;

public class IntSetUtil {
    public static final String INT_SET_FACTORY_CONFIG_PROPERTY_NAME = "com.ibm.wala.mutableIntSetFactory";
    private static MutableIntSetFactory<?> defaultIntSetFactory;
    private static final boolean DEBUG = false;

    static {
        MutableSharedBitVectorIntSetFactory defaultFactory = new MutableSharedBitVectorIntSetFactory();
        if (System.getProperty(INT_SET_FACTORY_CONFIG_PROPERTY_NAME) != null) {
            try {
                Class<?> intSetFactoryClass = Class.forName(System.getProperty(INT_SET_FACTORY_CONFIG_PROPERTY_NAME));
                MutableIntSetFactory intSetFactory = (MutableIntSetFactory)intSetFactoryClass.newInstance();
                IntSetUtil.setDefaultIntSetFactory(intSetFactory);
            }
            catch (Exception e) {
                System.err.println("Cannot use int set factory " + System.getProperty(INT_SET_FACTORY_CONFIG_PROPERTY_NAME));
                IntSetUtil.setDefaultIntSetFactory(defaultFactory);
            }
        } else {
            IntSetUtil.setDefaultIntSetFactory(defaultFactory);
        }
        assert (defaultIntSetFactory != null);
    }

    public static MutableIntSet make() {
        return defaultIntSetFactory.make();
    }

    public static MutableIntSet make(int[] initial) {
        return defaultIntSetFactory.make(initial);
    }

    private IntSetUtil() {
    }

    public static MutableIntSet makeMutableCopy(IntSet set) throws IllegalArgumentException, UnimplementedError {
        if (set == null) {
            throw new IllegalArgumentException("set == null");
        }
        if (set instanceof SparseIntSet) {
            return MutableSparseIntSet.make(set);
        }
        if (set instanceof BitVectorIntSet) {
            return new BitVectorIntSet(set);
        }
        if (set instanceof BimodalMutableIntSet) {
            return BimodalMutableIntSet.makeCopy(set);
        }
        if (set instanceof MutableSharedBitVectorIntSet) {
            return new MutableSharedBitVectorIntSet((MutableSharedBitVectorIntSet)set);
        }
        if (set instanceof SemiSparseMutableIntSet) {
            return new SemiSparseMutableIntSet((SemiSparseMutableIntSet)set);
        }
        if (set instanceof DebuggingMutableIntSet) {
            MutableIntSet pCopy = IntSetUtil.makeMutableCopy(((DebuggingMutableIntSet)set).primaryImpl);
            MutableIntSet sCopy = IntSetUtil.makeMutableCopy(((DebuggingMutableIntSet)set).secondaryImpl);
            return new DebuggingMutableIntSet(pCopy, sCopy);
        }
        if (set instanceof EmptyIntSet) {
            return IntSetUtil.make();
        }
        Assertions.UNREACHABLE(set.getClass().toString());
        return null;
    }

    public static IntSet diff(IntSet A2, IntSet B2) {
        if (A2 == null) {
            throw new IllegalArgumentException("null A");
        }
        if (B2 == null) {
            throw new IllegalArgumentException("null B");
        }
        return IntSetUtil.diff(A2, B2, IntSetUtil.getDefaultIntSetFactory());
    }

    private static IntSet defaultSlowDiff(IntSet A2, IntSet B2, MutableIntSetFactory<?> factory) {
        Object result = factory.makeCopy(A2);
        IntIterator it = B2.intIterator();
        while (it.hasNext()) {
            int I = it.next();
            result.remove(I);
        }
        return result;
    }

    public static IntSet diff(IntSet A2, IntSet B2, MutableIntSetFactory<?> factory) {
        if (factory == null) {
            throw new IllegalArgumentException("null factory");
        }
        if (A2 == null) {
            throw new IllegalArgumentException("null A");
        }
        if (B2 == null) {
            throw new IllegalArgumentException("null B");
        }
        if (A2 instanceof SparseIntSet && B2 instanceof SparseIntSet) {
            return SparseIntSet.diff((SparseIntSet)A2, (SparseIntSet)B2);
        }
        if (A2 instanceof SemiSparseMutableIntSet && B2 instanceof SemiSparseMutableIntSet) {
            SemiSparseMutableIntSet d = SemiSparseMutableIntSet.diff((SemiSparseMutableIntSet)A2, (SemiSparseMutableIntSet)B2);
            return d;
        }
        return IntSetUtil.defaultSlowDiff(A2, B2, factory);
    }

    public static MutableIntSet removeAll(MutableIntSet A2, IntSet B2) throws IllegalArgumentException {
        if (A2 == null) {
            throw new IllegalArgumentException("A == null");
        }
        if (B2 == null) {
            throw new IllegalArgumentException("B == null");
        }
        if (A2 instanceof SemiSparseMutableIntSet && B2 instanceof SemiSparseMutableIntSet) {
            return ((SemiSparseMutableIntSet)A2).removeAll((SemiSparseMutableIntSet)B2);
        }
        IntIterator it = B2.intIterator();
        while (it.hasNext()) {
            int I = it.next();
            A2.remove(I);
        }
        return A2;
    }

    public static int binarySearch(int[] data, int key, int low, int high) throws IllegalArgumentException {
        if (data == null) {
            throw new IllegalArgumentException("null array");
        }
        if (data.length == 0) {
            return -1;
        }
        if (low <= high && (low < 0 || high < 0)) {
            throw new IllegalArgumentException("can't search negative indices " + low + " " + high);
        }
        if (high > data.length - 1) {
            high = data.length - 1;
        }
        if (low <= high) {
            int mid = (low + high) / 2;
            int midValue = data[mid];
            if (midValue == key) {
                return mid;
            }
            if (midValue > key) {
                return IntSetUtil.binarySearch(data, key, low, mid - 1);
            }
            return IntSetUtil.binarySearch(data, key, mid + 1, high);
        }
        return -1;
    }

    public static MutableIntSetFactory<?> getDefaultIntSetFactory() {
        return defaultIntSetFactory;
    }

    public static void setDefaultIntSetFactory(MutableIntSetFactory<?> defaultIntSetFactory) {
        if (defaultIntSetFactory == null) {
            throw new IllegalArgumentException("null defaultIntSetFactory");
        }
        IntSetUtil.defaultIntSetFactory = defaultIntSetFactory;
    }

    public static IntSet add(IntSet s, int j) throws IllegalArgumentException {
        if (s == null) {
            throw new IllegalArgumentException("s == null");
        }
        if (s instanceof SparseIntSet) {
            SparseIntSet sis = (SparseIntSet)s;
            return SparseIntSet.add(sis, j);
        }
        MutableSparseIntSet result = MutableSparseIntSet.make(s);
        result.add(j);
        return result;
    }

    public static int[] toArray(IntSet s) {
        int i = 0;
        int[] result = new int[s.size()];
        IntIterator x = s.intIterator();
        while (x.hasNext()) {
            result[i++] = x.next();
        }
        assert (!x.hasNext());
        return result;
    }
}

