/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.intset;

import com.ibm.wala.util.intset.Bits;
import java.io.Serializable;

public final class FixedSizeBitVector
implements Cloneable,
Serializable {
    public static final long serialVersionUID = 33181877746462822L;
    private static final int LOG_BITS_PER_UNIT = 5;
    private static final int MASK = -1;
    private static final int LOW_MASK = 31;
    private int[] bits;
    private final int nbits;

    private static int subscript(int bitIndex) {
        return bitIndex >> 5;
    }

    public FixedSizeBitVector(int nbits) {
        if (nbits < 0) {
            throw new IllegalArgumentException("illegal nbits: " + nbits);
        }
        this.bits = new int[FixedSizeBitVector.subscript(nbits) + 1];
        this.nbits = nbits;
    }

    public FixedSizeBitVector(FixedSizeBitVector s) {
        if (s == null) {
            throw new IllegalArgumentException("s is null");
        }
        this.bits = new int[s.bits.length];
        this.nbits = s.nbits;
        this.copyBits(s);
    }

    public void setAll() {
        int i = 0;
        while (i < this.bits.length) {
            this.bits[i] = -1;
            ++i;
        }
    }

    public void set(int bit) {
        try {
            int shiftBits = bit & 0x1F;
            int n = FixedSizeBitVector.subscript(bit);
            this.bits[n] = this.bits[n] | 1 << shiftBits;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalArgumentException("invalid bit " + bit);
        }
    }

    public void clearAll() {
        int i = 0;
        while (i < this.bits.length) {
            this.bits[i] = 0;
            ++i;
        }
    }

    public void clear(int bit) {
        try {
            int shiftBits = bit & 0x1F;
            int n = FixedSizeBitVector.subscript(bit);
            this.bits[n] = this.bits[n] & ~(1 << shiftBits);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalArgumentException("invalid bit: " + bit);
        }
    }

    public boolean get(int bit) {
        if (bit < 0) {
            throw new IllegalArgumentException("illegal bit: " + bit);
        }
        int shiftBits = bit & 0x1F;
        int n = FixedSizeBitVector.subscript(bit);
        try {
            return (this.bits[n] & 1 << shiftBits) != 0;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return false;
        }
    }

    public void not() {
        int i = 0;
        while (i < this.bits.length) {
            int n = i++;
            this.bits[n] = ~this.bits[n];
        }
    }

    public static FixedSizeBitVector not(FixedSizeBitVector s) {
        FixedSizeBitVector b = new FixedSizeBitVector(s);
        b.not();
        return b;
    }

    public void and(FixedSizeBitVector set) {
        int n;
        if (set == null) {
            throw new IllegalArgumentException("null set");
        }
        if (this == set) {
            return;
        }
        int i = n = this.bits.length;
        while (i-- > 0) {
            int n2 = i;
            this.bits[n2] = this.bits[n2] & set.bits[i];
        }
    }

    public static FixedSizeBitVector and(FixedSizeBitVector b1, FixedSizeBitVector b2) {
        FixedSizeBitVector b = new FixedSizeBitVector(b1);
        b.and(b2);
        return b;
    }

    public void or(FixedSizeBitVector set) throws IllegalArgumentException {
        int setLength;
        if (set == null) {
            throw new IllegalArgumentException("set == null");
        }
        if (this == set) {
            return;
        }
        int i = setLength = set.bits.length;
        while (i-- > 0) {
            int n = i;
            this.bits[n] = this.bits[n] | set.bits[i];
        }
    }

    public static FixedSizeBitVector or(FixedSizeBitVector b1, FixedSizeBitVector b2) throws IllegalArgumentException {
        if (b2 == null) {
            throw new IllegalArgumentException("b2 == null");
        }
        FixedSizeBitVector b = new FixedSizeBitVector(b1);
        b.or(b2);
        return b;
    }

    public void xor(FixedSizeBitVector set) {
        int setLength;
        if (set == null) {
            throw new IllegalArgumentException("set is null");
        }
        int i = setLength = set.bits.length;
        while (i-- > 0) {
            int n = i;
            this.bits[n] = this.bits[n] ^ set.bits[i];
        }
    }

    public boolean intersectionEmpty(FixedSizeBitVector other) {
        int n;
        if (other == null) {
            throw new IllegalArgumentException("other is null");
        }
        int i = n = this.bits.length;
        while (i-- > 0) {
            if ((this.bits[i] & other.bits[i]) == 0) continue;
            return false;
        }
        return true;
    }

    public void copyBits(FixedSizeBitVector set) {
        int setLength;
        if (set == null) {
            throw new IllegalArgumentException("set is null");
        }
        int i = setLength = set.bits.length;
        while (i-- > 0) {
            this.bits[i] = set.bits[i];
        }
    }

    public int hashCode() {
        int h = 1234;
        int i = this.bits.length;
        while (--i >= 0) {
            h ^= this.bits[i] * (i + 1);
        }
        return h;
    }

    public int populationCount() {
        int count = 0;
        int i = 0;
        while (i < this.bits.length) {
            count += Bits.populationCount(this.bits[i]);
            ++i;
        }
        return count;
    }

    public int length() {
        return this.bits.length << 5;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof FixedSizeBitVector) {
            if (this == obj) {
                return true;
            }
            FixedSizeBitVector set = (FixedSizeBitVector)obj;
            int n = this.bits.length;
            if (n != set.bits.length) {
                return false;
            }
            int i = n;
            while (i-- > 0) {
                if (this.bits[i] == set.bits[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean isZero() {
        int setLength;
        int i = setLength = this.bits.length;
        while (i-- > 0) {
            if (this.bits[i] == 0) continue;
            return false;
        }
        return true;
    }

    public Object clone() {
        FixedSizeBitVector result = null;
        try {
            result = (FixedSizeBitVector)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
        result.bits = new int[this.bits.length];
        System.arraycopy(this.bits, 0, result.bits, 0, result.bits.length);
        return result;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        boolean needSeparator = false;
        buffer.append('{');
        int limit = this.nbits;
        int i = 0;
        while (i < limit) {
            if (this.get(i)) {
                if (needSeparator) {
                    buffer.append(", ");
                } else {
                    needSeparator = true;
                }
                buffer.append(i);
            }
            ++i;
        }
        buffer.append('}');
        return buffer.toString();
    }
}

