/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.intset;

import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.MapUtil;
import com.ibm.wala.util.intset.BitVectorIntSet;
import java.util.Map;
import java.util.WeakHashMap;

public class BitVectorRepository {
    private static final boolean STATS = false;
    private static final int STATS_WINDOW = 100;
    private static int queries = 0;
    private static int hits = 0;
    private static final int SUBSET_DELTA = 5;
    private static final Map<Object, WeakHashMap<BitVectorIntSet, Object>> buckets = HashMapFactory.make();

    public static synchronized BitVectorIntSet findOrCreateSharedSubset(BitVectorIntSet value) {
        int size;
        if (value == null) {
            throw new IllegalArgumentException("value is null");
        }
        int i = size = value.size();
        while (i > size - 5) {
            WeakHashMap<BitVectorIntSet, Object> m = buckets.get(i);
            if (m != null) {
                for (BitVectorIntSet bv : m.keySet()) {
                    if (!bv.isSubset(value)) continue;
                    return bv;
                }
            }
            --i;
        }
        WeakHashMap<BitVectorIntSet, Object> m = MapUtil.findOrCreateWeakHashMap(buckets, new Integer(size));
        BitVectorIntSet bv = new BitVectorIntSet(value);
        m.put(bv, null);
        return bv;
    }

    private static void reportStats() {
        double percent = 100.0 * (double)hits / (double)queries;
        System.err.println("BitVectorRepository: queries " + queries + " hits " + percent);
        System.err.println("                     entries " + BitVectorRepository.countEntries());
    }

    private static int countEntries() {
        int result = 0;
        for (WeakHashMap<BitVectorIntSet, Object> m : buckets.values()) {
            result += m.size();
        }
        return result;
    }
}

