/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.intset;

import com.ibm.wala.util.intset.Bits;
import java.io.Serializable;

public abstract class BitVectorBase<T extends BitVectorBase>
implements Cloneable,
Serializable {
    protected static final boolean DEBUG = false;
    protected static final int LOG_BITS_PER_UNIT = 5;
    protected static final int BITS_PER_UNIT = 32;
    protected static final int MASK = -1;
    protected static final int LOW_MASK = 31;
    protected int[] bits;
    private static final int[][] masks = new int[][]{{-65536}, {-16777216, 65280}, {-268435456, 0xF00000, 61440, 240}, {-1073741824, 0xC000000, 0xC00000, 786432, 49152, 3072, 192, 12}, {Integer.MIN_VALUE, 0x20000000, 0x8000000, 0x2000000, 0x800000, 0x200000, 524288, 131072, 32768, 8192, 2048, 512, 128, 32, 8, 2}};

    public abstract void set(int var1);

    public abstract void clear(int var1);

    public abstract boolean get(int var1);

    public abstract int length();

    public abstract void and(T var1);

    public abstract void andNot(T var1);

    public abstract void or(T var1);

    public abstract void xor(T var1);

    public abstract boolean sameBits(T var1);

    public abstract boolean isSubset(T var1);

    public abstract boolean intersectionEmpty(T var1);

    public static int subscript(int bitIndex) {
        return bitIndex >> 5;
    }

    public final void clearAll() {
        int i = 0;
        while (i < this.bits.length) {
            this.bits[i] = 0;
            ++i;
        }
    }

    public int hashCode() {
        int h = 1234;
        int i = this.bits.length - 1;
        while (i >= 0) {
            h ^= this.bits[i] * (i + 1);
            --i;
        }
        return h;
    }

    public final int populationCount() {
        int count = 0;
        int i = 0;
        while (i < this.bits.length) {
            count += Bits.populationCount(this.bits[i]);
            ++i;
        }
        return count;
    }

    public boolean isZero() {
        int setLength = this.bits.length;
        int i = setLength - 1;
        while (i >= 0) {
            if (this.bits[i] != 0) {
                return false;
            }
            --i;
        }
        return true;
    }

    public Object clone() {
        BitVectorBase result = null;
        try {
            result = (BitVectorBase)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
        result.bits = new int[this.bits.length];
        System.arraycopy(this.bits, 0, result.bits, 0, result.bits.length);
        return result;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        boolean needSeparator = false;
        buffer.append('{');
        int limit = this.length();
        int i = 0;
        while (i < limit) {
            if (this.get(i)) {
                if (needSeparator) {
                    buffer.append(", ");
                } else {
                    needSeparator = true;
                }
                buffer.append(i);
            }
            ++i;
        }
        buffer.append('}');
        return buffer.toString();
    }

    public boolean contains(int i) {
        return this.get(i);
    }

    public int max() {
        int lastWord = this.bits.length - 1;
        while (lastWord >= 0 && this.bits[lastWord] == 0) {
            --lastWord;
        }
        if (lastWord < 0) {
            return -1;
        }
        int count = lastWord * 32;
        int top = this.bits[lastWord];
        int j = 0;
        int i = 0;
        while (i < masks.length) {
            if ((top & masks[i][j]) != 0) {
                j <<= 1;
            } else {
                j <<= 1;
                ++j;
            }
            ++i;
        }
        return count + (31 - j);
    }

    public int nextSetBit(int start) {
        if (start < 0) {
            throw new IllegalArgumentException("illegal start: " + start);
        }
        int word = BitVectorBase.subscript(start);
        int bit = 1 << (start & 0x1F);
        while (word < this.bits.length) {
            if (this.bits[word] != 0) {
                do {
                    if ((this.bits[word] & bit) != 0) {
                        return start;
                    }
                    ++start;
                } while ((bit <<= 1) != 0);
            } else {
                start += 32 - (start & 0x1F);
            }
            ++word;
            bit = 1;
        }
        return -1;
    }

    public void copyBits(BitVectorBase set) {
        if (set == null) {
            throw new IllegalArgumentException("set is null");
        }
        int setLength = set.bits.length;
        this.bits = new int[setLength];
        int i = setLength - 1;
        while (i >= 0) {
            this.bits[i] = set.bits[i];
            --i;
        }
    }
}

