/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.intset;

import com.ibm.wala.util.intset.BitVectorBase;
import com.ibm.wala.util.intset.Bits;

public class BitVector
extends BitVectorBase<BitVector> {
    private static final long serialVersionUID = 9087259335807761617L;
    private static final int MAX_BITS = 0x1FFFFFFF;

    public BitVector() {
        this(1);
    }

    public BitVector(int nbits) {
        if (nbits > 0x1FFFFFFF || nbits < 0) {
            throw new IllegalArgumentException("invalid nbits: " + nbits);
        }
        this.bits = new int[BitVector.subscript(nbits) + 1];
    }

    void expand(int newCapacity) {
        int[] oldbits = this.bits;
        this.bits = new int[BitVector.subscript(newCapacity) + 1];
        int i = 0;
        while (i < oldbits.length) {
            this.bits[i] = oldbits[i];
            ++i;
        }
    }

    public BitVector(BitVector s) {
        if (s == null) {
            throw new IllegalArgumentException("s is null");
        }
        this.bits = new int[s.bits.length];
        this.copyBits(s);
    }

    @Override
    public final void set(int bit) {
        int shiftBits = bit & 0x1F;
        int subscript = BitVector.subscript(bit);
        if (subscript >= this.bits.length) {
            this.expand(bit);
        }
        try {
            int n = subscript;
            this.bits[n] = this.bits[n] | 1 << shiftBits;
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
    }

    @Override
    public final void clear(int bit) {
        if (bit < 0) {
            throw new IllegalArgumentException("invalid bit: " + bit);
        }
        int ss = BitVector.subscript(bit);
        if (ss >= this.bits.length) {
            return;
        }
        int shiftBits = bit & 0x1F;
        int n = ss;
        this.bits[n] = this.bits[n] & ~(1 << shiftBits);
    }

    @Override
    public final boolean get(int bit) {
        if (bit < 0) {
            throw new IllegalArgumentException("illegal bit: " + bit);
        }
        int ss = BitVector.subscript(bit);
        if (ss >= this.bits.length) {
            return false;
        }
        int shiftBits = bit & 0x1F;
        return (this.bits[ss] & 1 << shiftBits) != 0;
    }

    public static BitVector not(BitVector s) {
        BitVector b = new BitVector(s);
        b.not();
        return b;
    }

    @Override
    public final void and(BitVector set) {
        if (set == null) {
            throw new IllegalArgumentException("null set");
        }
        if (this == set) {
            return;
        }
        int n = Math.min(this.bits.length, set.bits.length);
        int i = n - 1;
        while (i >= 0) {
            int n2 = i;
            this.bits[n2] = this.bits[n2] & set.bits[i];
            --i;
        }
        i = n;
        while (i < this.bits.length) {
            this.bits[i] = 0;
            ++i;
        }
    }

    public static BitVector and(BitVector b1, BitVector b2) {
        if (b1 == null) {
            throw new IllegalArgumentException("null b1");
        }
        if (b2 == null) {
            throw new IllegalArgumentException("null b2");
        }
        BitVector b = new BitVector(b1);
        b.and(b2);
        return b;
    }

    @Override
    public final void or(BitVector set) {
        if (set == null) {
            throw new IllegalArgumentException("null set");
        }
        if (this == set) {
            return;
        }
        this.ensureCapacity(set);
        int n = Math.min(this.bits.length, set.bits.length);
        int i = n - 1;
        while (i >= 0) {
            int n2 = i;
            this.bits[n2] = this.bits[n2] | set.bits[i];
            --i;
        }
    }

    private void ensureCapacity(BitVector set) {
        if (set.bits.length > this.bits.length) {
            this.expand(32 * set.bits.length - 1);
        }
    }

    public final int orWithDelta(BitVector set) {
        if (set == null) {
            throw new IllegalArgumentException("set is null");
        }
        int delta = 0;
        this.ensureCapacity(set);
        int[] otherBits = set.bits;
        int n = Math.min(this.bits.length, otherBits.length);
        int i = n - 1;
        while (i >= 0) {
            int v1 = this.bits[i];
            int v2 = otherBits[i];
            if (v1 != v2) {
                delta -= Bits.populationCount(v1);
                int v3 = v1 | v2;
                delta += Bits.populationCount(v3);
                this.bits[i] = v3;
            }
            --i;
        }
        return delta;
    }

    public static BitVector or(BitVector b1, BitVector b2) {
        if (b1 == null) {
            throw new IllegalArgumentException("null b1");
        }
        if (b2 == null) {
            throw new IllegalArgumentException("null b2");
        }
        BitVector b = new BitVector(b1);
        b.or(b2);
        return b;
    }

    public static BitVector xor(BitVector b1, BitVector b2) {
        if (b1 == null) {
            throw new IllegalArgumentException("null b1");
        }
        if (b2 == null) {
            throw new IllegalArgumentException("null b2");
        }
        BitVector b = new BitVector(b1);
        b.xor(b2);
        return b;
    }

    @Override
    public final void xor(BitVector set) {
        if (set == null) {
            throw new IllegalArgumentException("set is null");
        }
        this.ensureCapacity(set);
        int n = Math.min(this.bits.length, set.bits.length);
        int i = n - 1;
        while (i >= 0) {
            int n2 = i;
            this.bits[n2] = this.bits[n2] ^ set.bits[i];
            --i;
        }
    }

    @Override
    public final boolean intersectionEmpty(BitVector other) {
        if (other == null) {
            throw new IllegalArgumentException("other is null");
        }
        int n = Math.min(this.bits.length, other.bits.length);
        int i = n - 1;
        while (i >= 0) {
            if ((this.bits[i] & other.bits[i]) != 0) {
                return false;
            }
            --i;
        }
        return true;
    }

    @Override
    public final int length() {
        return this.bits.length << 5;
    }

    @Override
    public final boolean sameBits(BitVector B2) {
        int i;
        if (B2 == null) {
            throw new IllegalArgumentException("null B");
        }
        if (this == B2) {
            return true;
        }
        int n = Math.min(this.bits.length, B2.bits.length);
        if (this.bits.length > B2.bits.length) {
            i = n;
            while (i < this.bits.length) {
                if (this.bits[i] != 0) {
                    return false;
                }
                ++i;
            }
        } else if (B2.bits.length > this.bits.length) {
            i = n;
            while (i < B2.bits.length) {
                if (B2.bits[i] != 0) {
                    return false;
                }
                ++i;
            }
        }
        i = n - 1;
        while (i >= 0) {
            if (this.bits[i] != B2.bits[i]) {
                return false;
            }
            --i;
        }
        return true;
    }

    @Override
    public boolean isSubset(BitVector other) {
        if (other == null) {
            throw new IllegalArgumentException("null other");
        }
        if (this == other) {
            return true;
        }
        int i = 0;
        while (i < this.bits.length) {
            if (i >= other.bits.length ? this.bits[i] != 0 : (this.bits[i] & ~other.bits[i]) != 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public void andNot(BitVector vector) {
        if (vector == null) {
            throw new IllegalArgumentException("null vector");
        }
        int ai = 0;
        int bi = 0;
        ai = 0;
        bi = 0;
        while (ai < this.bits.length && bi < vector.bits.length) {
            this.bits[ai] = this.bits[ai] & ~vector.bits[bi];
            ++ai;
            ++bi;
        }
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof BitVector) {
            if (this == obj) {
                return true;
            }
            BitVector set = (BitVector)obj;
            return this.sameBits(set);
        }
        return false;
    }

    public final void setAll() {
        int i = 0;
        while (i < this.bits.length) {
            this.bits[i] = -1;
            ++i;
        }
    }

    public final void not() {
        int i = 0;
        while (i < this.bits.length) {
            int n = i++;
            this.bits[n] = ~this.bits[n];
        }
    }

    public static BitVector andNot(BitVector b1, BitVector b2) {
        BitVector b = new BitVector(b1);
        b.andNot(b2);
        return b;
    }
}

