/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.intset;

import com.ibm.wala.util.collections.IVector;
import com.ibm.wala.util.collections.SimpleVector;
import com.ibm.wala.util.collections.TwoLevelVector;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.intset.BimodalMutableIntSet;
import com.ibm.wala.util.intset.IBinaryNaturalRelation;
import com.ibm.wala.util.intset.IntIterator;
import com.ibm.wala.util.intset.IntPair;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.IntVector;
import com.ibm.wala.util.intset.MutableIntSet;
import com.ibm.wala.util.intset.MutableSparseIntSet;
import com.ibm.wala.util.intset.SimpleIntVector;
import com.ibm.wala.util.intset.SparseIntSet;
import com.ibm.wala.util.intset.TunedSimpleIntVector;
import com.ibm.wala.util.intset.TwoLevelIntVector;
import java.util.Iterator;

public final class BasicNaturalRelation
implements IBinaryNaturalRelation {
    private static final boolean VERBOSE = false;
    private static final boolean DEBUG = false;
    public static final byte SIMPLE = 0;
    public static final byte TWO_LEVEL = 1;
    public static final byte SIMPLE_SPACE_STINGY = 2;
    private static final int EMPTY_CODE = -1;
    private static final int DELEGATE_CODE = -2;
    final IntVector[] smallStore;
    final IVector<IntSet> delegateStore;
    private int maxX = -1;

    public BasicNaturalRelation(byte[] implementation, byte vectorImpl) throws IllegalArgumentException {
        if (implementation == null) {
            throw new IllegalArgumentException("implementation is null");
        }
        if (implementation.length == 0) {
            throw new IllegalArgumentException("implementation.length == 0");
        }
        this.smallStore = new IntVector[implementation.length];
        int i = 0;
        while (i < implementation.length) {
            switch (implementation[i]) {
                case 0: {
                    this.smallStore[i] = new SimpleIntVector(-1);
                    break;
                }
                case 1: {
                    this.smallStore[i] = new TwoLevelIntVector(-1);
                    break;
                }
                case 2: {
                    this.smallStore[i] = new TunedSimpleIntVector(-1, 1, 1.1f);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unsupported implementation " + implementation[i]);
                }
            }
            ++i;
        }
        switch (vectorImpl) {
            case 0: {
                this.delegateStore = new SimpleVector<IntSet>();
                break;
            }
            case 1: {
                this.delegateStore = new TwoLevelVector<IntSet>();
                break;
            }
            default: {
                throw new IllegalArgumentException("unsupported implementation " + vectorImpl);
            }
        }
    }

    public BasicNaturalRelation() {
        this(new byte[1], 1);
    }

    @Override
    public boolean add(int x, int y) throws IllegalArgumentException {
        if (x < 0) {
            throw new IllegalArgumentException("illegal x: " + x);
        }
        if (y < 0) {
            throw new IllegalArgumentException("illegal y: " + y);
        }
        this.maxX = Math.max(this.maxX, x);
        MutableIntSet delegated = (MutableIntSet)this.delegateStore.get(x);
        if (delegated != null) {
            return delegated.add(y);
        }
        IntVector smallStore0 = this.smallStore[0];
        if (smallStore0.get(x) != -1) {
            int i = 0;
            IntVector v = null;
            int ssLength = this.smallStore.length;
            while (i < ssLength) {
                v = this.smallStore[i];
                int val = v.get(x);
                if (val == y) {
                    return false;
                }
                if (val == -1) break;
                ++i;
            }
            if (i == ssLength) {
                BimodalMutableIntSet s = new BimodalMutableIntSet(ssLength + 1, 1.1f);
                this.delegateStore.set(x, s);
                int j = 0;
                while (j < this.smallStore.length) {
                    IntVector vv = this.smallStore[j];
                    s.add(vv.get(x));
                    vv.set(x, -2);
                    ++j;
                }
                s.add(y);
            } else {
                v.set(x, y);
            }
            return true;
        }
        smallStore0.set(x, y);
        return true;
    }

    private boolean usingDelegate(int x) {
        return this.smallStore[0].get(x) == -2;
    }

    @Override
    public Iterator<IntPair> iterator() {
        return new TotalIterator();
    }

    private IntSet getDelegate(int x) {
        return this.delegateStore.get(x);
    }

    @Override
    public boolean anyRelated(int x) {
        return this.smallStore[0].get(x) != -1;
    }

    @Override
    public IntSet getRelated(int x) {
        int ss0 = this.smallStore[0].get(x);
        if (ss0 == -1) {
            return null;
        }
        if (ss0 == -2) {
            return this.getDelegate(x);
        }
        int ssLength = this.smallStore.length;
        if (ssLength == 2) {
            int ss1 = this.smallStore[1].get(x);
            if (ss1 == -1) {
                return SparseIntSet.singleton(ss0);
            }
            return SparseIntSet.pair(ss0, ss1);
        }
        if (ssLength == 1) {
            return SparseIntSet.singleton(ss0);
        }
        int ss1 = this.smallStore[1].get(x);
        if (ss1 == -1) {
            return SparseIntSet.singleton(ss0);
        }
        MutableSparseIntSet result = MutableSparseIntSet.createMutableSparseIntSet(ssLength);
        int i = 0;
        while (i < this.smallStore.length) {
            if (this.smallStore[i].get(x) == -1) break;
            result.add(this.smallStore[i].get(x));
            ++i;
        }
        return result;
    }

    @Override
    public int getRelatedCount(int x) throws IllegalArgumentException {
        if (x < 0) {
            throw new IllegalArgumentException("x must be greater than zero");
        }
        if (!this.anyRelated(x)) {
            return 0;
        }
        if (this.usingDelegate(x)) {
            return this.getDelegate(x).size();
        }
        int result = 0;
        int i = 0;
        while (i < this.smallStore.length) {
            if (this.smallStore[i].get(x) == -1) break;
            ++result;
            ++i;
        }
        return result;
    }

    @Override
    public void remove(int x, int y) {
        block9: {
            block8: {
                if (x < 0) {
                    throw new IllegalArgumentException("illegal x: " + x);
                }
                if (y < 0) {
                    throw new IllegalArgumentException("illegal y: " + y);
                }
                if (!this.usingDelegate(x)) break block8;
                MutableIntSet s = (MutableIntSet)this.delegateStore.get(x);
                s.remove(y);
                if (s.size() != 0) break block9;
                this.delegateStore.set(x, null);
                int i = 0;
                while (i < this.smallStore.length) {
                    this.smallStore[i].set(x, -1);
                    ++i;
                }
                break block9;
            }
            int i = 0;
            while (i < this.smallStore.length) {
                if (this.smallStore[i].get(x) == y) {
                    int j = i;
                    while (j < this.smallStore.length) {
                        if (j < this.smallStore.length - 1) {
                            this.smallStore[j].set(x, this.smallStore[j + 1].get(x));
                        } else {
                            this.smallStore[j].set(x, -1);
                        }
                        ++j;
                    }
                    return;
                }
                ++i;
            }
        }
    }

    @Override
    public void removeAll(int x) {
        int i = 0;
        while (i < this.smallStore.length) {
            this.smallStore[i].set(x, -1);
            ++i;
        }
        this.delegateStore.set(x, null);
    }

    @Override
    public void performVerboseAction() {
    }

    private int countPairs() {
        int result = 0;
        Iterator<IntPair> it = this.iterator();
        while (it.hasNext()) {
            it.next();
            ++result;
        }
        return result;
    }

    @Override
    public boolean contains(int x, int y) {
        if (x < 0) {
            throw new IllegalArgumentException("invalid x: " + x);
        }
        if (y < 0) {
            throw new IllegalArgumentException("invalid y: " + y);
        }
        if (this.usingDelegate(x)) {
            return this.getDelegate(x).contains(y);
        }
        int i = 0;
        while (i < this.smallStore.length) {
            if (this.smallStore[i].get(x) == y) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public int maxKeyValue() {
        return this.maxX;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i <= this.maxX) {
            result.append(i).append(":");
            result.append(this.getRelated(i));
            result.append("\n");
            ++i;
        }
        return result.toString();
    }

    private class TotalIterator
    implements Iterator<IntPair> {
        private int nextX = -1;
        private int nextIndex = -1;
        private IntIterator delegateIterator = null;

        TotalIterator() {
            this.advanceX();
        }

        private void advanceX() {
            this.delegateIterator = null;
            int i = this.nextX + 1;
            while (i <= BasicNaturalRelation.this.maxX) {
                if (BasicNaturalRelation.this.anyRelated(i)) {
                    this.nextX = i;
                    this.nextIndex = this.getFirstIndex(i);
                    if (this.nextIndex == BasicNaturalRelation.this.smallStore.length) {
                        IntSet s = BasicNaturalRelation.this.delegateStore.get(i);
                        assert (s.size() > 0);
                        this.delegateIterator = s.intIterator();
                    }
                    return;
                }
                ++i;
            }
            this.nextX = -1;
        }

        private int getFirstIndex(int x) {
            if (BasicNaturalRelation.this.smallStore[0].get(x) >= 0) {
                return 0;
            }
            return BasicNaturalRelation.this.smallStore.length;
        }

        @Override
        public boolean hasNext() {
            return this.nextX != -1;
        }

        @Override
        public IntPair next() {
            IntPair result = null;
            if (this.nextIndex == BasicNaturalRelation.this.smallStore.length) {
                int y = this.delegateIterator.next();
                result = new IntPair(this.nextX, y);
                if (!this.delegateIterator.hasNext()) {
                    this.advanceX();
                }
            } else {
                result = new IntPair(this.nextX, BasicNaturalRelation.this.smallStore[this.nextIndex].get(this.nextX));
                if (this.nextIndex == BasicNaturalRelation.this.smallStore.length - 1 || BasicNaturalRelation.this.smallStore[this.nextIndex + 1].get(this.nextX) == -1) {
                    this.advanceX();
                } else {
                    ++this.nextIndex;
                }
            }
            return result;
        }

        @Override
        public void remove() {
            Assertions.UNREACHABLE();
        }
    }
}

