/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.graph.traverse;

import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.Pair;
import com.ibm.wala.util.graph.Graph;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;

public class WelshPowell<T> {
    public static <T> Comparator<T> defaultComparator(final Graph<T> G) {
        return new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                int o2edges;
                int o1edges = G.getSuccNodeCount(o1) + G.getPredNodeCount(o1);
                if (o1edges != (o2edges = G.getSuccNodeCount(o2) + G.getPredNodeCount(o2))) {
                    return o1edges - o2edges;
                }
                return o1.toString().compareTo(o2.toString());
            }
        };
    }

    public Pair<Map<T, Integer>, Integer> color(Graph<T> G) {
        return this.color(G, WelshPowell.defaultComparator(G));
    }

    public Pair<Map<T, Integer>, Integer> color(Graph<T> G, Comparator<T> order) {
        HashMap colors = HashMapFactory.make();
        TreeSet<T> vertices = new TreeSet<T>(order);
        for (Object n : G) {
            vertices.add(n);
        }
        int currentColor = 0;
        while (colors.size() < G.getNumberOfNodes()) {
            for (Object n : vertices) {
                if (colors.containsKey(n)) continue;
                colors.put(n, currentColor);
                block3: for (Object m : vertices) {
                    if (colors.containsKey(m)) continue;
                    Iterator ps = G.getPredNodes(m);
                    while (ps.hasNext()) {
                        Object p = ps.next();
                        if (colors.containsKey(p) && (Integer)colors.get(p) == currentColor) continue block3;
                    }
                    Iterator ss = G.getSuccNodes(m);
                    while (ss.hasNext()) {
                        Object s = ss.next();
                        if (colors.containsKey(s) && (Integer)colors.get(s) == currentColor) continue block3;
                    }
                    colors.put(m, currentColor);
                }
                ++currentColor;
            }
        }
        return Pair.make(colors, currentColor);
    }
}

