/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.graph.traverse;

import com.ibm.wala.util.graph.NumberedGraph;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.IntSetAction;
import com.ibm.wala.util.intset.IntSetUtil;
import com.ibm.wala.util.intset.MutableIntSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class FloydWarshall<T> {
    protected final NumberedGraph<T> G;

    public FloydWarshall(NumberedGraph<T> g) {
        this.G = g;
    }

    protected int edgeCost(int from, int to) {
        return 1;
    }

    protected void pathCallback(int i, int j, int k) {
    }

    int[][] allPairsShortestPaths() {
        final int[][] result = new int[this.G.getNumberOfNodes()][this.G.getNumberOfNodes()];
        int i = 0;
        while (i < result.length) {
            int j = 0;
            while (j < result[i].length) {
                result[i][j] = Integer.MAX_VALUE;
                ++j;
            }
            ++i;
        }
        for (Object from : this.G) {
            final int fn = this.G.getNumber(from);
            IntSet tos = this.G.getSuccNodeNumbers(from);
            tos.foreach(new IntSetAction(){

                @Override
                public void act(int x) {
                    result[fn][x] = FloydWarshall.this.edgeCost(fn, x);
                }
            });
        }
        for (Object kn : this.G) {
            int k = this.G.getNumber(kn);
            for (Object in : this.G) {
                int i2 = this.G.getNumber(in);
                for (Object jn : this.G) {
                    int j = this.G.getNumber(jn);
                    long newLen = (long)result[i2][k] + (long)result[k][j];
                    if (newLen <= (long)result[i2][j]) {
                        this.pathCallback(i2, j, k);
                    }
                    if (newLen >= (long)result[i2][j]) continue;
                    result[i2][j] = (int)newLen;
                }
            }
        }
        return result;
    }

    public static <T> int[][] shortestPathLengths(NumberedGraph<T> G) {
        return new FloydWarshall<T>(G).allPairsShortestPaths();
    }

    public static <T> GetPath<T> allPairsShortestPath(NumberedGraph<T> G) {
        return (new FloydWarshall<T>((NumberedGraph)G){
            int[][] next;
            {
                this.next = new int[this.G.getNumberOfNodes()][this.G.getNumberOfNodes()];
            }

            @Override
            protected void pathCallback(int i, int j, int k) {
                this.next[i][j] = k;
            }

            private GetPath<T> doit() {
                int i = 0;
                while (i < this.next.length) {
                    int j = 0;
                    while (j < this.next[i].length) {
                        this.next[i][j] = -1;
                        ++j;
                    }
                    ++i;
                }
                final int[][] paths = this.allPairsShortestPaths();
                return new GetPath<T>(){

                    @Override
                    public List<T> getPath(T from, T to) {
                        int tn;
                        int fn = G.getNumber(from);
                        if (paths[fn][tn = G.getNumber(to)] == Integer.MAX_VALUE) {
                            throw new UnsupportedOperationException("no path from " + from + " to " + to);
                        }
                        int intermediate = next[fn][tn];
                        if (intermediate == -1) {
                            return Collections.emptyList();
                        }
                        Object in = G.getNode(intermediate);
                        LinkedList result = new LinkedList(this.getPath(from, in));
                        result.add(in);
                        result.addAll(this.getPath(in, to));
                        return result;
                    }
                };
            }
        }).doit();
    }

    public static <T> GetPaths<T> allPairsShortestPaths(NumberedGraph<T> G) {
        return (new FloydWarshall<T>((NumberedGraph)G){
            MutableIntSet[][] next;
            {
                this.next = new MutableIntSet[this.G.getNumberOfNodes()][this.G.getNumberOfNodes()];
            }

            @Override
            protected void pathCallback(int i, int j, int k) {
                if (this.next[i][j] == null) {
                    this.next[i][j] = IntSetUtil.make();
                }
                this.next[i][j].add(k);
            }

            private GetPaths<T> doit() {
                final int[][] paths = this.allPairsShortestPaths();
                return new GetPaths<T>(){

                    @Override
                    public Set<List<T>> getPaths(final T from, final T to) {
                        int tn;
                        int fn = G.getNumber(from);
                        if (paths[fn][tn = G.getNumber(to)] == Integer.MAX_VALUE) {
                            throw new UnsupportedOperationException("no path from " + from + " to " + to);
                        }
                        MutableIntSet intermediate = next[fn][tn];
                        if (intermediate == null) {
                            List none = Collections.emptyList();
                            return Collections.singleton(none);
                        }
                        final HashSet result = new HashSet();
                        intermediate.foreach(new IntSetAction(){

                            @Override
                            public void act(int x) {
                                Object in = G.getNode(x);
                                for (List pre : this.getPaths(from, in)) {
                                    for (List post : this.getPaths(in, to)) {
                                        LinkedList path = new LinkedList(pre);
                                        path.add(in);
                                        path.addAll(post);
                                        result.add(path);
                                    }
                                }
                            }
                        });
                        return result;
                    }
                };
            }
        }).doit();
    }

    public static interface GetPath<T> {
        public List<T> getPath(T var1, T var2);
    }

    public static interface GetPaths<T> {
        public Set<List<T>> getPaths(T var1, T var2);
    }
}

