/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.graph.impl;

import com.ibm.wala.util.graph.AbstractNumberedGraph;
import com.ibm.wala.util.graph.Graph;
import com.ibm.wala.util.graph.NumberedEdgeManager;
import com.ibm.wala.util.graph.NumberedNodeManager;
import com.ibm.wala.util.graph.impl.SlowNumberedNodeManager;
import com.ibm.wala.util.graph.impl.SparseNumberedEdgeManager;
import java.util.Iterator;

public class SlowSparseNumberedGraph<T>
extends AbstractNumberedGraph<T> {
    private final SlowNumberedNodeManager<T> nodeManager = new SlowNumberedNodeManager();
    private final SparseNumberedEdgeManager<T> edgeManager;

    protected SlowSparseNumberedGraph() {
        this(0);
    }

    public SlowSparseNumberedGraph(int normalOutCount) {
        this.edgeManager = new SparseNumberedEdgeManager<T>(this.nodeManager, normalOutCount, 1);
    }

    @Override
    public NumberedNodeManager<T> getNodeManager() {
        return this.nodeManager;
    }

    @Override
    public NumberedEdgeManager<T> getEdgeManager() {
        return this.edgeManager;
    }

    public static <T> SlowSparseNumberedGraph<T> duplicate(Graph<T> g) {
        SlowSparseNumberedGraph<T> result = SlowSparseNumberedGraph.make();
        SlowSparseNumberedGraph.copyInto(g, result);
        return result;
    }

    public static <T> void copyInto(Graph<T> g, Graph<T> into) {
        if (g == null) {
            throw new IllegalArgumentException("g is null");
        }
        Iterator it = g.iterator();
        while (it.hasNext()) {
            into.addNode(it.next());
        }
        for (Object n : g) {
            Iterator it2 = g.getSuccNodes(n);
            while (it2.hasNext()) {
                into.addEdge(n, it2.next());
            }
        }
    }

    public static <T> SlowSparseNumberedGraph<T> make() {
        return new SlowSparseNumberedGraph<T>();
    }
}

