/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.graph.dominators;

import com.ibm.wala.util.graph.NumberedGraph;
import com.ibm.wala.util.graph.dominators.Dominators;

public class NumberedDominators<T>
extends Dominators<T> {
    private final Object[] infoMap;

    public NumberedDominators(NumberedGraph<T> G, T root) throws IllegalArgumentException {
        super(G, root);
        this.infoMap = new Object[G.getMaxNumber() + 1];
        for (Object n : G) {
            this.infoMap[G.getNumber(n)] = new Dominators.DominatorInfo(this, n);
        }
        this.analyze();
    }

    @Override
    public NumberedGraph<T> getGraph() {
        return (NumberedGraph)this.G;
    }

    @Override
    protected final Dominators.DominatorInfo getInfo(T node) {
        assert (node != null);
        return (Dominators.DominatorInfo)this.infoMap[this.getGraph().getNumber(node)];
    }
}

