/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.config;

import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.ipa.callgraph.impl.SetOfClasses;
import com.ibm.wala.types.TypeReference;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FileOfClasses
extends SetOfClasses
implements Serializable {
    private static final long serialVersionUID = -3256390509887654322L;
    private static final boolean DEBUG = false;
    private Pattern pattern = null;
    private String regex = null;
    private boolean needsCompile = false;

    private FileOfClasses(File textFile) throws IOException {
        this(new FileInputStream(textFile));
    }

    public static FileOfClasses createFileOfClasses(File textFile) throws IOException {
        if (textFile == null) {
            throw new IllegalArgumentException("null textFile");
        }
        return new FileOfClasses(textFile);
    }

    public FileOfClasses(InputStream input) throws IOException {
        String line;
        if (input == null) {
            throw new IllegalArgumentException("null input");
        }
        BufferedReader is = new BufferedReader(new InputStreamReader(input));
        StringBuffer regex = null;
        while ((line = is.readLine()) != null) {
            if (regex == null) {
                regex = new StringBuffer("(" + line + ")");
                continue;
            }
            regex.append("|(" + line + ")");
        }
        if (regex != null) {
            this.regex = regex.toString();
            this.needsCompile = true;
        }
        is.close();
    }

    private void compile() {
        this.pattern = Pattern.compile(this.regex);
        this.needsCompile = false;
    }

    public boolean contains(TypeReference klass) {
        if (klass == null) {
            throw new IllegalArgumentException("klass is null");
        }
        if (klass.isPrimitiveType()) {
            return false;
        }
        String klassName = klass.getName().toString().substring(1);
        return this.contains(klassName);
    }

    public boolean contains(String klassName) {
        if (this.needsCompile) {
            this.compile();
        }
        if (this.pattern == null) {
            return false;
        }
        Matcher m = this.pattern.matcher(klassName);
        return m.matches();
    }

    public void add(IClass klass) {
        if (klass == null) {
            throw new IllegalArgumentException("klass is null");
        }
        this.regex = this.regex == null ? klass.getReference().getName().toString() : String.valueOf(this.regex) + '|' + klass.getReference().getName().toString();
        this.needsCompile = true;
    }

    public String toString() {
        return this.regex;
    }
}

