/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.collections;

import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.debug.UnimplementedError;
import com.ibm.wala.util.intset.OrdinalSetMapping;
import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ObjectArrayMapping<T>
implements OrdinalSetMapping<T> {
    private final T[] array;
    private final HashMap<T, Integer> map = HashMapFactory.make();

    public ObjectArrayMapping(T[] array) {
        if (array == null) {
            throw new IllegalArgumentException("null array");
        }
        this.array = array;
        int i = 0;
        while (i < array.length) {
            this.map.put(array[i], i);
            ++i;
        }
    }

    @Override
    public T getMappedObject(int n) throws NoSuchElementException {
        try {
            return this.array[n];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalArgumentException("invalid n: " + n);
        }
    }

    @Override
    public int getMappedIndex(Object o) {
        if (this.map.get(o) == null) {
            return -1;
        }
        return this.map.get(o);
    }

    @Override
    public boolean hasMappedIndex(Object o) {
        return this.map.get(o) != null;
    }

    @Override
    public Iterator<T> iterator() {
        return this.map.keySet().iterator();
    }

    @Override
    public int add(Object o) throws UnimplementedError {
        Assertions.UNREACHABLE();
        return 0;
    }

    @Override
    public int getMaximumIndex() {
        return this.array.length - 1;
    }

    @Override
    public int getSize() {
        return this.map.size();
    }
}

