/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.collections;

import com.ibm.wala.util.collections.Filter;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class FilterIterator<T>
implements Iterator<T> {
    final Iterator<?> i;
    final Filter f;
    private T next = null;
    private boolean done = false;

    public FilterIterator(Iterator<?> i, Filter f) {
        if (i == null) {
            throw new IllegalArgumentException("null i");
        }
        if (f == null) {
            throw new IllegalArgumentException("null f");
        }
        this.i = i;
        this.f = f;
        this.advance();
    }

    private void advance() {
        while (this.i.hasNext()) {
            Object o = this.i.next();
            if (!this.f.accepts(o)) continue;
            this.next = o;
            return;
        }
        this.done = true;
    }

    @Override
    public T next() throws NoSuchElementException {
        if (this.done) {
            throw new NoSuchElementException();
        }
        T o = this.next;
        this.advance();
        return o;
    }

    @Override
    public boolean hasNext() {
        return !this.done;
    }

    @Override
    public void remove() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return "filter " + this.f + " of " + this.i;
    }
}

