/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util;

import com.ibm.wala.util.CancelException;

public class MonitorUtil {
    public static void beginTask(IProgressMonitor monitor, String task, int totalWork) throws CancelException {
        if (monitor != null) {
            monitor.beginTask(task, totalWork);
            if (monitor.isCanceled()) {
                throw CancelException.make("cancelled in " + task);
            }
        }
    }

    public static void done(IProgressMonitor monitor) throws CancelException {
        if (monitor != null) {
            monitor.done();
            if (monitor.isCanceled()) {
                throw CancelException.make("cancelled in " + monitor.toString());
            }
        }
    }

    public static void worked(IProgressMonitor monitor, int units) throws CancelException {
        if (monitor != null) {
            monitor.worked(units);
            if (monitor.isCanceled()) {
                throw CancelException.make("cancelled in " + monitor.toString());
            }
        }
    }

    public static void throwExceptionIfCanceled(IProgressMonitor progressMonitor) throws CancelException {
        if (progressMonitor != null && progressMonitor.isCanceled()) {
            throw CancelException.make("operation cancelled");
        }
    }

    public static interface IProgressMonitor {
        public void beginTask(String var1, int var2);

        public boolean isCanceled();

        public void done();

        public void worked(int var1);
    }
}

