/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.types.annotations;

import com.ibm.wala.shrikeCT.AnnotationsReader;
import com.ibm.wala.shrikeCT.InvalidClassFileException;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.Pair;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Annotation {
    private final TypeReference type;
    private final Map<String, AnnotationsReader.ElementValue> namedArguments;
    private final Pair<TypeReference, Object>[] unnamedArguments;

    private Annotation(TypeReference type, Map<String, AnnotationsReader.ElementValue> namedArguments, Pair<TypeReference, Object>[] unnamedArguments) {
        this.type = type;
        if (namedArguments == null) {
            throw new IllegalArgumentException("namedArguments is null");
        }
        this.namedArguments = namedArguments;
        this.unnamedArguments = unnamedArguments;
    }

    public static Annotation makeUnnamedAndNamed(TypeReference t, Map<String, AnnotationsReader.ElementValue> namedArguments, Pair<TypeReference, Object>[] unnamedArguments) {
        return new Annotation(t, namedArguments, unnamedArguments);
    }

    public static Annotation makeWithUnnamed(TypeReference t, Pair<TypeReference, Object>[] unnamedArguments) {
        return new Annotation(t, Collections.<String, AnnotationsReader.ElementValue>emptyMap(), unnamedArguments);
    }

    public static Annotation make(TypeReference t) {
        return new Annotation(t, Collections.<String, AnnotationsReader.ElementValue>emptyMap(), null);
    }

    public static Annotation makeWithNamed(TypeReference t, Map<String, AnnotationsReader.ElementValue> namedArguments) {
        return new Annotation(t, namedArguments, null);
    }

    public static Collection<Annotation> getAnnotationsFromReader(AnnotationsReader r, ClassLoaderReference clRef) throws InvalidClassFileException {
        if (r != null) {
            AnnotationsReader.AnnotationAttribute[] allAnnotations = r.getAllAnnotations();
            HashSet<Annotation> result = HashSetFactory.make();
            AnnotationsReader.AnnotationAttribute[] annotationAttributeArray = allAnnotations;
            int n = allAnnotations.length;
            int n2 = 0;
            while (n2 < n) {
                AnnotationsReader.AnnotationAttribute annot = annotationAttributeArray[n2];
                String type = annot.type;
                type = type.replaceAll(";", "");
                TypeReference t = TypeReference.findOrCreate(clRef, type);
                result.add(Annotation.makeWithNamed(t, annot.elementValues));
                ++n2;
            }
            return result;
        }
        return Collections.emptySet();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Annotation type " + this.type);
        if (this.unnamedArguments != null) {
            sb.append("[");
            Pair<TypeReference, Object>[] pairArray = this.unnamedArguments;
            int n = this.unnamedArguments.length;
            int n2 = 0;
            while (n2 < n) {
                Pair<TypeReference, Object> arg = pairArray[n2];
                sb.append(" " + ((TypeReference)arg.fst).getName().getClassName() + ":" + arg.snd);
                ++n2;
            }
            sb.append(" ]");
        }
        if (!this.namedArguments.isEmpty()) {
            sb.append(" " + this.namedArguments);
        }
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.unnamedArguments);
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Annotation other = (Annotation)obj;
        if (!Arrays.equals(this.unnamedArguments, other.unnamedArguments)) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }

    public Pair<TypeReference, Object>[] getUnnamedArguments() {
        return this.unnamedArguments;
    }

    public Map<String, AnnotationsReader.ElementValue> getNamedArguments() {
        return this.namedArguments;
    }

    public TypeReference getType() {
        return this.type;
    }
}

