/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ssa.analysis;

import com.ibm.wala.cfg.ControlFlowGraph;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.ISSABasicBlock;
import com.ibm.wala.ssa.SSACFG;
import com.ibm.wala.ssa.SSAGetCaughtExceptionInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAPhiInstruction;
import com.ibm.wala.ssa.SSAPiInstruction;
import com.ibm.wala.ssa.analysis.IExplodedBasicBlock;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.EmptyIterator;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.Iterator2Collection;
import com.ibm.wala.util.collections.NonNullSingletonIterator;
import com.ibm.wala.util.collections.SimpleVector;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.debug.UnimplementedError;
import com.ibm.wala.util.intset.BitVector;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.MutableSparseIntSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExplodedControlFlowGraph
implements ControlFlowGraph<SSAInstruction, IExplodedBasicBlock> {
    private static final int ENTRY_INDEX = -1;
    private static final int EXIT_INDEX = -2;
    private final IR ir;
    private final SimpleVector<IExplodedBasicBlock> normalNodes = new SimpleVector();
    private final Collection<IExplodedBasicBlock> allNodes = HashSetFactory.make();
    private final IExplodedBasicBlock entry;
    private final IExplodedBasicBlock exit;

    private ExplodedControlFlowGraph(IR ir) {
        assert (ir != null);
        this.ir = ir;
        this.entry = new ExplodedBasicBlock(-1, null);
        this.exit = new ExplodedBasicBlock(-2, null);
        this.createNodes();
    }

    private void createNodes() {
        this.allNodes.add(this.entry);
        this.allNodes.add(this.exit);
        for (ISSABasicBlock b : this.ir.getControlFlowGraph()) {
            int i = b.getFirstInstructionIndex();
            while (i <= b.getLastInstructionIndex()) {
                ExplodedBasicBlock bb = new ExplodedBasicBlock(i, b);
                this.normalNodes.set(i, bb);
                this.allNodes.add(bb);
                ++i;
            }
        }
    }

    public static ExplodedControlFlowGraph make(IR ir) {
        if (ir == null) {
            throw new IllegalArgumentException("ir == null");
        }
        return new ExplodedControlFlowGraph(ir);
    }

    @Override
    public IExplodedBasicBlock entry() {
        return this.entry;
    }

    @Override
    public IExplodedBasicBlock exit() {
        return this.exit;
    }

    @Override
    public IExplodedBasicBlock getBlockForInstruction(int index) {
        return this.normalNodes.get(index);
    }

    @Override
    public BitVector getCatchBlocks() {
        BitVector original = this.ir.getControlFlowGraph().getCatchBlocks();
        BitVector result = new BitVector();
        int i = 0;
        while (i <= original.max()) {
            if (original.get(i)) {
                result.set(i + 1);
            }
            ++i;
        }
        return result;
    }

    @Override
    public Collection<IExplodedBasicBlock> getExceptionalPredecessors(IExplodedBasicBlock bb) {
        ExplodedBasicBlock eb = (ExplodedBasicBlock)bb;
        assert (eb != null);
        if (eb.equals(this.entry)) {
            return Collections.emptySet();
        }
        if (eb.isExitBlock() || eb.instructionIndex == eb.original.getFirstInstructionIndex()) {
            ArrayList<IExplodedBasicBlock> result = new ArrayList<IExplodedBasicBlock>();
            for (ISSABasicBlock s : this.ir.getControlFlowGraph().getExceptionalPredecessors(eb.original)) {
                assert (this.normalNodes.get(s.getLastInstructionIndex()) != null);
                result.add(this.normalNodes.get(s.getLastInstructionIndex()));
            }
            return result;
        }
        return Collections.emptySet();
    }

    @Override
    public List<IExplodedBasicBlock> getExceptionalSuccessors(IExplodedBasicBlock bb) {
        ExplodedBasicBlock eb = (ExplodedBasicBlock)bb;
        assert (eb != null);
        if (eb.equals(this.exit)) {
            return Collections.emptyList();
        }
        if (eb.isEntryBlock() || eb.instructionIndex == eb.original.getLastInstructionIndex()) {
            ArrayList<IExplodedBasicBlock> result = new ArrayList<IExplodedBasicBlock>();
            for (ISSABasicBlock s : this.ir.getControlFlowGraph().getExceptionalSuccessors(eb.original)) {
                if (s.equals(this.ir.getControlFlowGraph().exit())) {
                    result.add(this.exit());
                    continue;
                }
                assert (this.normalNodes.get(s.getFirstInstructionIndex()) != null);
                result.add(this.normalNodes.get(s.getFirstInstructionIndex()));
            }
            return result;
        }
        return Collections.emptyList();
    }

    public SSAInstruction[] getInstructions() {
        return this.ir.getInstructions();
    }

    @Override
    public IMethod getMethod() throws UnimplementedError {
        return this.ir.getMethod();
    }

    @Override
    public Collection<IExplodedBasicBlock> getNormalPredecessors(IExplodedBasicBlock bb) {
        ExplodedBasicBlock eb = (ExplodedBasicBlock)bb;
        assert (eb != null);
        if (eb.equals(this.entry)) {
            return Collections.emptySet();
        }
        if (eb.isExitBlock() || eb.instructionIndex == eb.original.getFirstInstructionIndex()) {
            ArrayList<IExplodedBasicBlock> result = new ArrayList<IExplodedBasicBlock>();
            for (ISSABasicBlock s : this.ir.getControlFlowGraph().getNormalPredecessors(eb.original)) {
                if (s.equals(this.ir.getControlFlowGraph().entry())) {
                    if (s.getLastInstructionIndex() >= 0) {
                        assert (this.normalNodes.get(s.getLastInstructionIndex()) != null);
                        result.add(this.normalNodes.get(s.getLastInstructionIndex()));
                        continue;
                    }
                    result.add(this.entry());
                    continue;
                }
                assert (this.normalNodes.get(s.getLastInstructionIndex()) != null);
                result.add(this.normalNodes.get(s.getLastInstructionIndex()));
            }
            return result;
        }
        assert (this.normalNodes.get(eb.instructionIndex - 1) != null);
        return Collections.singleton(this.normalNodes.get(eb.instructionIndex - 1));
    }

    @Override
    public Collection<IExplodedBasicBlock> getNormalSuccessors(IExplodedBasicBlock bb) {
        ExplodedBasicBlock eb = (ExplodedBasicBlock)bb;
        assert (eb != null);
        if (eb.equals(this.exit)) {
            return Collections.emptySet();
        }
        if (eb.isEntryBlock()) {
            return Collections.singleton(this.normalNodes.get(0));
        }
        if (eb.instructionIndex == eb.original.getLastInstructionIndex()) {
            ArrayList<IExplodedBasicBlock> result = new ArrayList<IExplodedBasicBlock>();
            for (ISSABasicBlock s : this.ir.getControlFlowGraph().getNormalSuccessors(eb.original)) {
                if (s.equals(this.ir.getControlFlowGraph().exit())) {
                    result.add(this.exit());
                    continue;
                }
                assert (this.normalNodes.get(s.getFirstInstructionIndex()) != null);
                result.add(this.normalNodes.get(s.getFirstInstructionIndex()));
            }
            return result;
        }
        assert (this.normalNodes.get(eb.instructionIndex + 1) != null);
        return Collections.singleton(this.normalNodes.get(eb.instructionIndex + 1));
    }

    @Override
    public int getProgramCounter(int index) throws UnimplementedError {
        return this.ir.getControlFlowGraph().getProgramCounter(index);
    }

    @Override
    public void removeNodeAndEdges(IExplodedBasicBlock N) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addNode(IExplodedBasicBlock n) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsNode(IExplodedBasicBlock N) {
        return this.allNodes.contains(N);
    }

    @Override
    public int getNumberOfNodes() {
        return this.allNodes.size();
    }

    @Override
    public Iterator<IExplodedBasicBlock> iterator() {
        return this.allNodes.iterator();
    }

    @Override
    public void removeNode(IExplodedBasicBlock n) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addEdge(IExplodedBasicBlock src, IExplodedBasicBlock dst) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getPredNodeCount(IExplodedBasicBlock bb) throws IllegalArgumentException {
        ExplodedBasicBlock eb = (ExplodedBasicBlock)bb;
        if (eb == null) {
            throw new IllegalArgumentException("eb == null");
        }
        if (eb.isEntryBlock()) {
            return 0;
        }
        if (eb.isExitBlock()) {
            return this.ir.getControlFlowGraph().getPredNodeCount(this.ir.getControlFlowGraph().exit());
        }
        if (eb.instructionIndex == eb.original.getFirstInstructionIndex()) {
            if (eb.original.isEntryBlock()) {
                return 1;
            }
            return this.ir.getControlFlowGraph().getPredNodeCount(eb.original);
        }
        return 1;
    }

    @Override
    public Iterator<IExplodedBasicBlock> getPredNodes(IExplodedBasicBlock bb) throws IllegalArgumentException {
        ISSABasicBlock original;
        ExplodedBasicBlock eb = (ExplodedBasicBlock)bb;
        if (eb == null) {
            throw new IllegalArgumentException("eb == null");
        }
        if (eb.isEntryBlock()) {
            return EmptyIterator.instance();
        }
        ISSABasicBlock iSSABasicBlock = original = eb.isExitBlock() ? this.ir.getControlFlowGraph().exit() : eb.original;
        if (eb.isExitBlock() || eb.instructionIndex == eb.original.getFirstInstructionIndex()) {
            ArrayList<IExplodedBasicBlock> result = new ArrayList<IExplodedBasicBlock>();
            if (eb.original != null && eb.original.isEntryBlock()) {
                result.add(this.entry);
            }
            Iterator<ISSABasicBlock> it = this.ir.getControlFlowGraph().getPredNodes(original);
            while (it.hasNext()) {
                ISSABasicBlock s = it.next();
                if (s.isEntryBlock()) {
                    if (s.getLastInstructionIndex() >= 0) {
                        result.add(this.normalNodes.get(s.getLastInstructionIndex()));
                        continue;
                    }
                    result.add(this.entry);
                    continue;
                }
                assert (this.normalNodes.get(s.getLastInstructionIndex()) != null);
                result.add(this.normalNodes.get(s.getLastInstructionIndex()));
            }
            return result.iterator();
        }
        assert (this.normalNodes.get(eb.instructionIndex - 1) != null);
        return NonNullSingletonIterator.make(this.normalNodes.get(eb.instructionIndex - 1));
    }

    @Override
    public int getSuccNodeCount(IExplodedBasicBlock N) throws UnimplementedError {
        return Iterator2Collection.toSet(this.getSuccNodes(N)).size();
    }

    @Override
    public Iterator<IExplodedBasicBlock> getSuccNodes(IExplodedBasicBlock bb) {
        ExplodedBasicBlock eb = (ExplodedBasicBlock)bb;
        assert (eb != null);
        if (eb.isExitBlock()) {
            return EmptyIterator.instance();
        }
        if (eb.isEntryBlock()) {
            IExplodedBasicBlock z = this.normalNodes.get(0);
            return z == null ? EmptyIterator.instance() : NonNullSingletonIterator.make(z);
        }
        if (eb.instructionIndex == eb.original.getLastInstructionIndex()) {
            ArrayList<IExplodedBasicBlock> result = new ArrayList<IExplodedBasicBlock>();
            Iterator<ISSABasicBlock> it = this.ir.getControlFlowGraph().getSuccNodes(eb.original);
            while (it.hasNext()) {
                ISSABasicBlock s = it.next();
                if (s.equals(this.ir.getControlFlowGraph().exit())) {
                    result.add(this.exit());
                    continue;
                }
                if (this.normalNodes.get(s.getFirstInstructionIndex()) == null) continue;
                result.add(this.normalNodes.get(s.getFirstInstructionIndex()));
            }
            return result.iterator();
        }
        assert (this.normalNodes.get(eb.instructionIndex + 1) != null);
        return NonNullSingletonIterator.make(this.normalNodes.get(eb.instructionIndex + 1));
    }

    @Override
    public boolean hasEdge(IExplodedBasicBlock src, IExplodedBasicBlock dst) throws UnimplementedError {
        Assertions.UNREACHABLE();
        return false;
    }

    @Override
    public void removeAllIncidentEdges(IExplodedBasicBlock node) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeEdge(IExplodedBasicBlock src, IExplodedBasicBlock dst) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeIncomingEdges(IExplodedBasicBlock node) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeOutgoingEdges(IExplodedBasicBlock node) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getMaxNumber() {
        return this.getNumberOfNodes() - 1;
    }

    @Override
    public IExplodedBasicBlock getNode(int number) {
        if (number == 0) {
            return this.entry();
        }
        if (number == this.getNumberOfNodes() - 1) {
            return this.exit();
        }
        return this.normalNodes.get(number - 1);
    }

    @Override
    public int getNumber(IExplodedBasicBlock n) throws IllegalArgumentException {
        if (n == null) {
            throw new IllegalArgumentException("n == null");
        }
        return n.getNumber();
    }

    @Override
    public Iterator<IExplodedBasicBlock> iterateNodes(IntSet s) throws UnimplementedError {
        Assertions.UNREACHABLE();
        return null;
    }

    @Override
    public IntSet getPredNodeNumbers(IExplodedBasicBlock node) {
        MutableSparseIntSet result = MutableSparseIntSet.makeEmpty();
        Iterator<IExplodedBasicBlock> it = this.getPredNodes(node);
        while (it.hasNext()) {
            result.add(this.getNumber(it.next()));
        }
        return result;
    }

    @Override
    public IntSet getSuccNodeNumbers(IExplodedBasicBlock node) throws UnimplementedError {
        Assertions.UNREACHABLE();
        return null;
    }

    public String toString() {
        StringBuffer s = new StringBuffer("");
        for (IExplodedBasicBlock bb : this) {
            s.append("BB").append(this.getNumber(bb)).append("\n");
            Iterator<IExplodedBasicBlock> succNodes = this.getSuccNodes(bb);
            while (succNodes.hasNext()) {
                s.append("    -> BB").append(this.getNumber(succNodes.next())).append("\n");
            }
        }
        return s.toString();
    }

    public IR getIR() {
        return this.ir;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ExplodedBasicBlock
    implements IExplodedBasicBlock {
        private final int instructionIndex;
        private final ISSABasicBlock original;

        public ExplodedBasicBlock(int instructionIndex, ISSABasicBlock original) {
            this.instructionIndex = instructionIndex;
            this.original = original;
        }

        public ExplodedControlFlowGraph getExplodedCFG() {
            return ExplodedControlFlowGraph.this;
        }

        @Override
        public Iterator<TypeReference> getCaughtExceptionTypes() {
            if (this.original instanceof SSACFG.ExceptionHandlerBasicBlock) {
                SSACFG.ExceptionHandlerBasicBlock eb = (SSACFG.ExceptionHandlerBasicBlock)this.original;
                return eb.getCaughtExceptionTypes();
            }
            return EmptyIterator.instance();
        }

        @Override
        public int getFirstInstructionIndex() {
            return this.instructionIndex;
        }

        @Override
        public int getLastInstructionIndex() {
            return this.instructionIndex;
        }

        @Override
        public IMethod getMethod() {
            return ExplodedControlFlowGraph.this.getMethod();
        }

        @Override
        public int getNumber() {
            if (this.isEntryBlock()) {
                return 0;
            }
            if (this.isExitBlock()) {
                return ExplodedControlFlowGraph.this.getNumberOfNodes() - 1;
            }
            return this.instructionIndex + 1;
        }

        @Override
        public boolean isCatchBlock() {
            if (this.original == null) {
                return false;
            }
            return this.original.isCatchBlock() && this.instructionIndex == this.original.getFirstInstructionIndex();
        }

        @Override
        public SSAGetCaughtExceptionInstruction getCatchInstruction() {
            if (!(this.original instanceof SSACFG.ExceptionHandlerBasicBlock)) {
                throw new IllegalArgumentException("block does not represent an exception handler");
            }
            SSACFG.ExceptionHandlerBasicBlock e = (SSACFG.ExceptionHandlerBasicBlock)this.original;
            return e.getCatchInstruction();
        }

        @Override
        public boolean isEntryBlock() {
            return this.instructionIndex == -1;
        }

        @Override
        public boolean isExitBlock() {
            return this.instructionIndex == -2;
        }

        @Override
        public int getGraphNodeId() {
            return this.getNumber();
        }

        @Override
        public void setGraphNodeId(int number) {
            Assertions.UNREACHABLE();
        }

        @Override
        public Iterator<SSAInstruction> iterator() {
            if (this.isEntryBlock() || this.isExitBlock() || this.getInstruction() == null) {
                return EmptyIterator.instance();
            }
            return NonNullSingletonIterator.make(this.getInstruction());
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.instructionIndex;
            result = 31 * result + (this.original == null ? 0 : this.original.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ExplodedBasicBlock other = (ExplodedBasicBlock)obj;
            if (this.instructionIndex != other.instructionIndex) {
                return false;
            }
            return !(this.original == null ? other.original != null : !this.original.equals(other.original));
        }

        @Override
        public SSAInstruction getInstruction() {
            if (this.isEntryBlock() || this.isExitBlock()) {
                return null;
            }
            return ExplodedControlFlowGraph.this.ir.getInstructions()[this.instructionIndex];
        }

        @Override
        public SSAInstruction getLastInstruction() {
            if (this.getLastInstructionIndex() < 0) {
                return null;
            }
            return ExplodedControlFlowGraph.this.ir.getInstructions()[this.getLastInstructionIndex()];
        }

        @Override
        public Iterator<SSAPhiInstruction> iteratePhis() {
            if (this.isEntryBlock() || this.isExitBlock() || this.instructionIndex != this.original.getFirstInstructionIndex()) {
                return EmptyIterator.instance();
            }
            return this.original.iteratePhis();
        }

        @Override
        public Iterator<SSAPiInstruction> iteratePis() {
            if (this.isEntryBlock() || this.isExitBlock() || this.instructionIndex != this.original.getLastInstructionIndex()) {
                return EmptyIterator.instance();
            }
            return this.original.iteratePis();
        }

        public String toString() {
            if (this.isEntryBlock()) {
                return "ExplodedBlock[" + this.getNumber() + "](entry:" + this.getMethod() + ")";
            }
            if (this.isExitBlock()) {
                return "ExplodedBlock[" + this.getNumber() + "](exit:" + this.getMethod() + ")";
            }
            return "ExplodedBlock[" + this.getNumber() + "](original:" + this.original + ")";
        }
    }
}

