/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ssa.analysis;

import com.ibm.wala.fixedpoint.impl.DefaultFixedPointSolver;
import com.ibm.wala.fixpoint.BooleanVariable;
import com.ibm.wala.fixpoint.UnaryOr;
import com.ibm.wala.ssa.DefUse;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSACFG;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAPhiInstruction;
import com.ibm.wala.util.CancelException;
import com.ibm.wala.util.CancelRuntimeException;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class DeadAssignmentElimination {
    private static final boolean DEBUG = false;

    public static void perform(IR ir) {
        if (ir == null) {
            throw new IllegalArgumentException("ir is null");
        }
        DefUse DU = new DefUse(ir);
        DeadValueSystem system = new DeadValueSystem(ir, DU);
        try {
            system.solve(null);
        }
        catch (CancelException e) {
            throw new CancelRuntimeException(e);
        }
        DeadAssignmentElimination.doTransformation(ir, system);
    }

    private static void doTransformation(IR ir, DeadValueSystem solution) {
        SSACFG cfg = ir.getControlFlowGraph();
        for (SSACFG.BasicBlock b : cfg) {
            if (!b.hasPhi()) continue;
            HashSet<SSAPhiInstruction> toRemove = HashSetFactory.make(5);
            Iterator<SSAPhiInstruction> it = b.iteratePhis();
            while (it.hasNext()) {
                int def;
                SSAPhiInstruction phi = it.next();
                if (phi == null || !solution.isDead(def = phi.getDef())) continue;
                toRemove.add(phi);
            }
            b.removePhis(toRemove);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DeadValueSystem
    extends DefaultFixedPointSolver<BooleanVariable> {
        private final Map<Integer, BooleanVariable> vars = HashMapFactory.make();
        private final HashSet<Integer> trivialDead = HashSetFactory.make();

        DeadValueSystem(IR ir, DefUse DU) {
            SSAInstruction u;
            Iterator<SSAInstruction> uses;
            Iterator<Object> it = ir.iteratePhis();
            while (it.hasNext()) {
                SSAPhiInstruction sSAPhiInstruction = (SSAPhiInstruction)it.next();
                if (sSAPhiInstruction == null) continue;
                int def = sSAPhiInstruction.getDef();
                if (DU.getNumberOfUses(def) == 0) {
                    this.trivialDead.add(new Integer(def));
                    continue;
                }
                boolean maybeDead = true;
                uses = DU.getUses(def);
                while (uses.hasNext()) {
                    u = uses.next();
                    if (u instanceof SSAPhiInstruction) continue;
                    maybeDead = false;
                    break;
                }
                if (!maybeDead) continue;
                BooleanVariable B2 = new BooleanVariable(false);
                this.vars.put(new Integer(def), B2);
            }
            for (Map.Entry entry : this.vars.entrySet()) {
                Integer def = (Integer)entry.getKey();
                BooleanVariable B3 = (BooleanVariable)entry.getValue();
                uses = DU.getUses(def);
                while (uses.hasNext()) {
                    u = (SSAPhiInstruction)uses.next();
                    Integer ud = new Integer(((SSAPhiInstruction)u).getDef());
                    if (this.trivialDead.contains(ud)) continue;
                    if (!this.vars.keySet().contains(ud)) {
                        B3.set(true);
                        continue;
                    }
                    BooleanVariable U = this.vars.get(ud);
                    this.newStatement(B3, UnaryOr.instance(), U, true, false);
                }
            }
        }

        @Override
        protected void initializeVariables() {
        }

        @Override
        protected void initializeWorkList() {
            this.addAllStatementsToWorkList();
        }

        private boolean isDead(int value) {
            Integer V = value;
            if (this.trivialDead.contains(V)) {
                return true;
            }
            BooleanVariable B2 = this.vars.get(V);
            if (B2 == null) {
                return false;
            }
            return !B2.getValue();
        }

        protected BooleanVariable[] makeStmtRHS(int size) {
            return new BooleanVariable[size];
        }
    }
}

