/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ssa;

import com.ibm.wala.ssa.SSAIndirectionData;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShrikeIndirectionData
implements SSAIndirectionData<ShrikeLocalName> {
    private final Map<ShrikeLocalName, Integer>[] defs;
    private final Map<ShrikeLocalName, Integer>[] uses;

    public ShrikeIndirectionData(int instructionArrayLength) {
        this.defs = new HashMap[instructionArrayLength];
        this.uses = new HashMap[instructionArrayLength];
    }

    @Override
    public int getDef(int instructionIndex, ShrikeLocalName name) {
        if (this.defs[instructionIndex] == null || !this.defs[instructionIndex].containsKey(name)) {
            return -1;
        }
        return this.defs[instructionIndex].get(name);
    }

    @Override
    public int getUse(int instructionIndex, ShrikeLocalName name) {
        if (this.uses[instructionIndex] == null || !this.uses[instructionIndex].containsKey(name)) {
            return -1;
        }
        return this.uses[instructionIndex].get(name);
    }

    @Override
    public void setDef(int instructionIndex, ShrikeLocalName name, int newDef) {
        if (this.defs[instructionIndex] == null) {
            this.defs[instructionIndex] = new HashMap<ShrikeLocalName, Integer>(2);
        }
        this.defs[instructionIndex].put(name, newDef);
    }

    @Override
    public void setUse(int instructionIndex, ShrikeLocalName name, int newUse) {
        if (this.uses[instructionIndex] == null) {
            this.uses[instructionIndex] = new HashMap<ShrikeLocalName, Integer>(2);
        }
        this.uses[instructionIndex].put(name, newUse);
    }

    @Override
    public Collection<ShrikeLocalName> getNames() {
        HashSet<ShrikeLocalName> result = new HashSet<ShrikeLocalName>();
        int i = 0;
        while (i < this.uses.length) {
            if (this.uses[i] != null) {
                result.addAll(this.uses[i].keySet());
            }
            if (this.defs[i] != null) {
                result.addAll(this.defs[i].keySet());
            }
            ++i;
        }
        return result;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < this.defs.length) {
            if (this.defs[i] != null) {
                result.append(String.valueOf(i) + " <- " + this.defs[i] + "\n");
            }
            if (this.uses[i] != null) {
                result.append(String.valueOf(i) + " -> " + this.uses[i] + "\n");
            }
            ++i;
        }
        return result.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ShrikeLocalName
    implements SSAIndirectionData.Name {
        private final int bytecodeLocalNumber;

        public ShrikeLocalName(int bytecodeLocalNumber) {
            this.bytecodeLocalNumber = bytecodeLocalNumber;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.bytecodeLocalNumber;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ShrikeLocalName other = (ShrikeLocalName)obj;
            return this.bytecodeLocalNumber == other.bytecodeLocalNumber;
        }

        public String toString() {
            return "(local:" + this.bytecodeLocalNumber + ")";
        }
    }
}

