/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ssa;

import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInstructionFactory;
import com.ibm.wala.ssa.SymbolTable;

public class SSAReturnInstruction
extends SSAInstruction {
    private final int result;
    private final boolean isPrimitive;

    public SSAReturnInstruction(int result, boolean isPrimitive) {
        this.result = result;
        this.isPrimitive = isPrimitive;
    }

    public SSAReturnInstruction() {
        this.result = -1;
        this.isPrimitive = false;
    }

    public SSAInstruction copyForSSA(SSAInstructionFactory insts, int[] defs, int[] uses) {
        if (this.result == -1) {
            return insts.ReturnInstruction();
        }
        if (uses != null && uses.length != 1) {
            throw new IllegalArgumentException("invalid uses.  must have exactly one use.");
        }
        return insts.ReturnInstruction(uses == null ? this.result : uses[0], this.isPrimitive);
    }

    public String toString(SymbolTable table) {
        if (this.result == -1) {
            return "return";
        }
        return "return " + this.getValueString(table, this.result);
    }

    public void visit(SSAInstruction.IVisitor v) {
        if (v == null) {
            throw new IllegalArgumentException("v is null");
        }
        v.visitReturn(this);
    }

    public int getNumberOfUses() {
        return this.result == -1 ? 0 : 1;
    }

    public int getUse(int j) {
        if (j != 0) {
            throw new IllegalArgumentException("illegal j: " + j);
        }
        return this.result;
    }

    public boolean returnsPrimitiveType() {
        return this.isPrimitive;
    }

    public int getResult() {
        return this.result;
    }

    public boolean returnsVoid() {
        return this.result == -1;
    }

    public int hashCode() {
        return this.result * 8933;
    }

    public boolean isFallThrough() {
        return false;
    }
}

