/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ssa;

import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInstructionFactory;
import com.ibm.wala.ssa.SymbolTable;

public class SSAPhiInstruction
extends SSAInstruction {
    private final int result;
    private int[] params;

    public SSAPhiInstruction(int result, int[] params) throws IllegalArgumentException {
        if (params == null) {
            throw new IllegalArgumentException("params is null");
        }
        this.result = result;
        this.params = params;
        if (params.length == 0) {
            throw new IllegalArgumentException("can't have phi with no params");
        }
        int[] nArray = params;
        int n = params.length;
        int n2 = 0;
        while (n2 < n) {
            int p = nArray[n2];
            if (p == 0) {
                throw new IllegalArgumentException("zero is an invalid value number for a parameter to phi");
            }
            ++n2;
        }
    }

    public SSAInstruction copyForSSA(SSAInstructionFactory insts, int[] defs, int[] uses) throws IllegalArgumentException {
        if (defs != null && defs.length == 0) {
            throw new IllegalArgumentException();
        }
        return insts.PhiInstruction(defs == null ? this.result : defs[0], uses == null ? this.params : uses);
    }

    public String toString(SymbolTable symbolTable) {
        StringBuffer s = new StringBuffer();
        s.append(this.getValueString(symbolTable, this.result)).append(" = phi ");
        s.append(" ").append(this.getValueString(symbolTable, this.params[0]));
        int i = 1;
        while (i < this.params.length) {
            s.append(",").append(this.getValueString(symbolTable, this.params[i]));
            ++i;
        }
        return s.toString();
    }

    public void visit(SSAInstruction.IVisitor v) {
        if (v == null) {
            throw new IllegalArgumentException("v is null");
        }
        v.visitPhi(this);
    }

    public boolean hasDef() {
        return true;
    }

    public int getDef() {
        return this.result;
    }

    public int getDef(int i) {
        if (i != 0) {
            throw new IllegalArgumentException("invalid i: " + i);
        }
        return this.result;
    }

    public int getNumberOfUses() {
        return this.params.length;
    }

    public int getNumberOfDefs() {
        return 1;
    }

    public int getUse(int j) throws IllegalArgumentException {
        if (j >= this.params.length || j < 0) {
            throw new IllegalArgumentException("Bad use " + j);
        }
        return this.params[j];
    }

    public void setValues(int[] i) {
        if (i == null || i.length < 1) {
            throw new IllegalArgumentException("illegal i: " + i);
        }
        this.params = i;
    }

    protected String getValueString(SymbolTable symbolTable, int valueNumber) {
        if (valueNumber == -1) {
            return "TOP";
        }
        return super.getValueString(symbolTable, valueNumber);
    }

    public int hashCode() {
        return 7823 * this.result;
    }

    public boolean isFallThrough() {
        return true;
    }
}

