/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ssa;

import com.ibm.wala.classLoader.NewSiteReference;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInstructionFactory;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.TypeReference;

public abstract class SSANewInstruction
extends SSAInstruction {
    private final int result;
    private final NewSiteReference site;
    private final int[] params;

    protected SSANewInstruction(int result, NewSiteReference site) throws IllegalArgumentException {
        if (site == null) {
            throw new IllegalArgumentException("site cannot be null");
        }
        assert (!site.getDeclaredType().isArrayType() || site.getDeclaredType().getClassLoader().getLanguage() != ClassLoaderReference.Java);
        this.result = result;
        this.site = site;
        this.params = null;
    }

    protected SSANewInstruction(int result, NewSiteReference site, int[] params) {
        if (params == null) {
            throw new IllegalArgumentException("params is null");
        }
        if (site == null) {
            throw new IllegalArgumentException("site is null");
        }
        assert (site.getDeclaredType().isArrayType() || site.getDeclaredType().getClassLoader().getLanguage() != ClassLoaderReference.Java);
        this.result = result;
        this.site = site;
        this.params = new int[params.length];
        System.arraycopy(params, 0, this.params, 0, params.length);
    }

    public SSAInstruction copyForSSA(SSAInstructionFactory insts, int[] defs, int[] uses) {
        if (this.params == null) {
            return insts.NewInstruction(defs == null ? this.result : defs[0], this.site);
        }
        return insts.NewInstruction(defs == null ? this.result : defs[0], this.site, uses == null ? this.params : uses);
    }

    public String toString(SymbolTable symbolTable) {
        return String.valueOf(this.getValueString(symbolTable, this.result)) + " = new " + this.site.getDeclaredType() + "@" + this.site.getProgramCounter() + (this.params == null ? "" : this.array2String(this.params, symbolTable));
    }

    private String array2String(int[] params, SymbolTable symbolTable) {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < params.length) {
            result.append(this.getValueString(symbolTable, params[i]));
            result.append(" ");
            ++i;
        }
        return result.toString();
    }

    public void visit(SSAInstruction.IVisitor v) {
        if (v == null) {
            throw new IllegalArgumentException("v is null");
        }
        v.visitNew(this);
    }

    public boolean hasDef() {
        return true;
    }

    public int getDef() {
        return this.result;
    }

    public int getDef(int i) {
        assert (i == 0);
        return this.result;
    }

    public int getNumberOfDefs() {
        return 1;
    }

    public TypeReference getConcreteType() {
        return this.site.getDeclaredType();
    }

    public NewSiteReference getNewSite() {
        return this.site;
    }

    public int hashCode() {
        return this.result * 7529 + this.site.getDeclaredType().hashCode();
    }

    public int getNumberOfUses() {
        return this.params == null ? 0 : this.params.length;
    }

    public int getUse(int j) {
        assert (this.params != null) : "expected params but got null";
        assert (this.params.length > j) : "found too few parameters";
        return this.params[j];
    }

    public boolean isPEI() {
        return true;
    }

    public boolean isFallThrough() {
        return true;
    }
}

