/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ssa;

import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInstructionFactory;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.types.TypeReference;

public abstract class SSALoadMetadataInstruction
extends SSAInstruction {
    private final int lval;
    private final Object token;
    private final TypeReference entityType;

    protected SSALoadMetadataInstruction(int lval, TypeReference entityType, Object token) {
        this.lval = lval;
        this.token = token;
        this.entityType = entityType;
        if (token == null) {
            throw new IllegalArgumentException("null typeRef");
        }
    }

    public SSAInstruction copyForSSA(SSAInstructionFactory insts, int[] defs, int[] uses) {
        if (defs != null && defs.length == 0) {
            throw new IllegalArgumentException("(defs != null) and (defs.length == 0)");
        }
        return insts.LoadMetadataInstruction(defs == null ? this.lval : defs[0], this.entityType, this.token);
    }

    public String toString(SymbolTable symbolTable) {
        return String.valueOf(this.getValueString(symbolTable, this.lval)) + " = load_metadata: " + this.token + ", " + this.entityType;
    }

    public void visit(SSAInstruction.IVisitor v) {
        if (v == null) {
            throw new IllegalArgumentException("v is null");
        }
        v.visitLoadMetadata(this);
    }

    public int hashCode() {
        return this.token.hashCode() * this.lval;
    }

    public boolean isPEI() {
        return true;
    }

    public boolean hasDef() {
        return true;
    }

    public int getDef() {
        return this.lval;
    }

    public int getDef(int i) {
        assert (i == 0);
        return this.lval;
    }

    public int getNumberOfDefs() {
        return 1;
    }

    public boolean isFallThrough() {
        return true;
    }

    public Object getToken() {
        return this.token;
    }

    public TypeReference getType() {
        return this.entityType;
    }
}

