/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ssa;

import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.shrikeBT.IInvokeInstruction;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInstructionFactory;
import com.ibm.wala.types.TypeReference;

public abstract class SSAInvokeInstruction
extends SSAAbstractInvokeInstruction {
    private final int result;
    private final int[] params;

    protected SSAInvokeInstruction(int result, int[] params, int exception, CallSiteReference site) {
        super(exception, site);
        this.result = result;
        this.params = params;
        SSAInvokeInstruction.assertParamsKosher(result, params, site);
    }

    protected SSAInvokeInstruction(int[] params, int exception, CallSiteReference site) {
        this(-1, params, exception, site);
    }

    public SSAInstruction copyForSSA(SSAInstructionFactory insts, int[] defs, int[] uses) {
        return insts.InvokeInstruction(defs == null || this.result == -1 ? this.result : defs[0], uses == null ? this.params : uses, defs == null ? this.exception : defs[this.result == -1 ? 0 : 1], this.site);
    }

    public static void assertParamsKosher(int result, int[] params, CallSiteReference site) throws IllegalArgumentException {
        if (site == null) {
            throw new IllegalArgumentException("site cannot be null");
        }
        if (site.getDeclaredTarget().getReturnType().equals(TypeReference.Void) && result != -1) assert (result == -1) : "bogus call to " + site;
        int nExpected = 0;
        if (!site.isStatic()) {
            ++nExpected;
        }
        if ((nExpected += site.getDeclaredTarget().getNumberOfParameters()) > 0) {
            if (params == null) assert (params != null) : "null params for " + site;
            if (params.length != nExpected) assert (params.length == nExpected) : "wrong number of params for " + site + " Expected " + nExpected + " got " + params.length;
        }
    }

    public void visit(SSAInstruction.IVisitor v) {
        if (v == null) {
            throw new IllegalArgumentException("v is null");
        }
        v.visitInvoke(this);
    }

    public int getNumberOfUses() {
        if (this.params == null) {
            assert (this.site.getInvocationCode() == IInvokeInstruction.Dispatch.STATIC || this.site.getInvocationCode() == IInvokeInstruction.Dispatch.SPECIAL);
            assert (this.site.getDeclaredTarget().getNumberOfParameters() == 0);
            return 0;
        }
        return this.params.length;
    }

    public int getNumberOfParameters() {
        return this.getNumberOfUses();
    }

    public int getNumberOfReturnValues() {
        return this.result == -1 ? 0 : 1;
    }

    public int getReturnValue(int i) {
        assert (i == 0 && this.result != -1);
        return this.result;
    }

    public int getUse(int j) {
        if (this.params == null) assert (false) : "Invalid getUse: " + j + " , null params " + this;
        if (this.params.length <= j) assert (this.params.length > j) : "Invalid getUse: " + this + ", index " + j + ", params.length " + this.params.length;
        return this.params[j];
    }

    public int hashCode() {
        return this.site.hashCode() * 7529 + this.exception * 9823;
    }
}

