/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ssa;

import com.ibm.wala.ssa.SSAArrayLengthInstruction;
import com.ibm.wala.ssa.SSAArrayLoadInstruction;
import com.ibm.wala.ssa.SSAArrayStoreInstruction;
import com.ibm.wala.ssa.SSABinaryOpInstruction;
import com.ibm.wala.ssa.SSACheckCastInstruction;
import com.ibm.wala.ssa.SSAComparisonInstruction;
import com.ibm.wala.ssa.SSAConditionalBranchInstruction;
import com.ibm.wala.ssa.SSAConversionInstruction;
import com.ibm.wala.ssa.SSAGetCaughtExceptionInstruction;
import com.ibm.wala.ssa.SSAGetInstruction;
import com.ibm.wala.ssa.SSAGotoInstruction;
import com.ibm.wala.ssa.SSAInstanceofInstruction;
import com.ibm.wala.ssa.SSAInstructionFactory;
import com.ibm.wala.ssa.SSAInvokeInstruction;
import com.ibm.wala.ssa.SSALoadMetadataInstruction;
import com.ibm.wala.ssa.SSAMonitorInstruction;
import com.ibm.wala.ssa.SSANewInstruction;
import com.ibm.wala.ssa.SSAPhiInstruction;
import com.ibm.wala.ssa.SSAPiInstruction;
import com.ibm.wala.ssa.SSAPutInstruction;
import com.ibm.wala.ssa.SSAReturnInstruction;
import com.ibm.wala.ssa.SSASwitchInstruction;
import com.ibm.wala.ssa.SSAThrowInstruction;
import com.ibm.wala.ssa.SSAUnaryOpInstruction;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.types.TypeReference;
import java.util.Collection;
import java.util.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SSAInstruction {
    protected SSAInstruction() {
    }

    public abstract SSAInstruction copyForSSA(SSAInstructionFactory var1, int[] var2, int[] var3);

    public abstract String toString(SymbolTable var1);

    public String toString() {
        return this.toString(null);
    }

    protected String getValueString(SymbolTable symbolTable, int valueNumber) {
        if (symbolTable == null) {
            return Integer.toString(valueNumber);
        }
        return symbolTable.getValueString(valueNumber);
    }

    public abstract void visit(IVisitor var1);

    public boolean hasDef() {
        return false;
    }

    public int getDef() {
        return -1;
    }

    public int getDef(int i) {
        return -1;
    }

    public int getNumberOfDefs() {
        return 0;
    }

    public int getNumberOfUses() {
        return 0;
    }

    public int getUse(int j) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public abstract int hashCode();

    public boolean isPEI() {
        return false;
    }

    public Collection<TypeReference> getExceptionTypes() {
        assert (!this.isPEI());
        return Collections.emptySet();
    }

    public abstract boolean isFallThrough();

    public final boolean equals(Object obj) {
        return this == obj;
    }

    public static interface IVisitor {
        public void visitGoto(SSAGotoInstruction var1);

        public void visitArrayLoad(SSAArrayLoadInstruction var1);

        public void visitArrayStore(SSAArrayStoreInstruction var1);

        public void visitBinaryOp(SSABinaryOpInstruction var1);

        public void visitUnaryOp(SSAUnaryOpInstruction var1);

        public void visitConversion(SSAConversionInstruction var1);

        public void visitComparison(SSAComparisonInstruction var1);

        public void visitConditionalBranch(SSAConditionalBranchInstruction var1);

        public void visitSwitch(SSASwitchInstruction var1);

        public void visitReturn(SSAReturnInstruction var1);

        public void visitGet(SSAGetInstruction var1);

        public void visitPut(SSAPutInstruction var1);

        public void visitInvoke(SSAInvokeInstruction var1);

        public void visitNew(SSANewInstruction var1);

        public void visitArrayLength(SSAArrayLengthInstruction var1);

        public void visitThrow(SSAThrowInstruction var1);

        public void visitMonitor(SSAMonitorInstruction var1);

        public void visitCheckCast(SSACheckCastInstruction var1);

        public void visitInstanceof(SSAInstanceofInstruction var1);

        public void visitPhi(SSAPhiInstruction var1);

        public void visitPi(SSAPiInstruction var1);

        public void visitGetCaughtException(SSAGetCaughtExceptionInstruction var1);

        public void visitLoadMetadata(SSALoadMetadataInstruction var1);
    }

    public static abstract class Visitor
    implements IVisitor {
        public void visitGoto(SSAGotoInstruction instruction) {
        }

        public void visitArrayLoad(SSAArrayLoadInstruction instruction) {
        }

        public void visitArrayStore(SSAArrayStoreInstruction instruction) {
        }

        public void visitBinaryOp(SSABinaryOpInstruction instruction) {
        }

        public void visitUnaryOp(SSAUnaryOpInstruction instruction) {
        }

        public void visitConversion(SSAConversionInstruction instruction) {
        }

        public void visitComparison(SSAComparisonInstruction instruction) {
        }

        public void visitConditionalBranch(SSAConditionalBranchInstruction instruction) {
        }

        public void visitSwitch(SSASwitchInstruction instruction) {
        }

        public void visitReturn(SSAReturnInstruction instruction) {
        }

        public void visitGet(SSAGetInstruction instruction) {
        }

        public void visitPut(SSAPutInstruction instruction) {
        }

        public void visitInvoke(SSAInvokeInstruction instruction) {
        }

        public void visitNew(SSANewInstruction instruction) {
        }

        public void visitArrayLength(SSAArrayLengthInstruction instruction) {
        }

        public void visitThrow(SSAThrowInstruction instruction) {
        }

        public void visitMonitor(SSAMonitorInstruction instruction) {
        }

        public void visitCheckCast(SSACheckCastInstruction instruction) {
        }

        public void visitInstanceof(SSAInstanceofInstruction instruction) {
        }

        public void visitPhi(SSAPhiInstruction instruction) {
        }

        public void visitPi(SSAPiInstruction instruction) {
        }

        public void visitGetCaughtException(SSAGetCaughtExceptionInstruction instruction) {
        }

        public void visitLoadMetadata(SSALoadMetadataInstruction instruction) {
        }
    }
}

