/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ssa;

import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInstructionFactory;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.types.TypeReference;

public class SSAInstanceofInstruction
extends SSAInstruction {
    private final int result;
    private final int ref;
    private final TypeReference checkedType;

    public SSAInstanceofInstruction(int result, int ref, TypeReference checkedType) {
        this.result = result;
        this.ref = ref;
        this.checkedType = checkedType;
    }

    public SSAInstruction copyForSSA(SSAInstructionFactory insts, int[] defs, int[] uses) {
        if (defs != null && defs.length == 0) {
            throw new IllegalArgumentException("defs.length == 0");
        }
        if (uses != null && uses.length == 0) {
            throw new IllegalArgumentException("uses.length == 0");
        }
        return insts.InstanceofInstruction(defs == null || defs.length == 0 ? this.result : defs[0], uses == null ? this.ref : uses[0], this.checkedType);
    }

    public String toString(SymbolTable symbolTable) {
        return String.valueOf(this.getValueString(symbolTable, this.result)) + " = instanceof " + this.getValueString(symbolTable, this.ref) + " " + this.checkedType;
    }

    public void visit(SSAInstruction.IVisitor v) throws NullPointerException {
        v.visitInstanceof(this);
    }

    public boolean hasDef() {
        return true;
    }

    public int getDef() {
        return this.result;
    }

    public int getDef(int i) {
        assert (i == 0);
        return this.result;
    }

    public TypeReference getCheckedType() {
        return this.checkedType;
    }

    public int getNumberOfDefs() {
        return 1;
    }

    public int getNumberOfUses() {
        return 1;
    }

    public int getUse(int j) {
        assert (j == 0);
        return this.ref;
    }

    public int hashCode() {
        return this.ref * 677 ^ this.result * 3803;
    }

    public boolean isFallThrough() {
        return true;
    }

    public int getRef() {
        return this.ref;
    }
}

