/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ssa;

import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInstructionFactory;
import com.ibm.wala.ssa.SymbolTable;

public class SSAGetCaughtExceptionInstruction
extends SSAInstruction {
    private final int exceptionValueNumber;
    private final int bbNumber;

    public SSAGetCaughtExceptionInstruction(int bbNumber, int exceptionValueNumber) {
        this.exceptionValueNumber = exceptionValueNumber;
        this.bbNumber = bbNumber;
    }

    public SSAInstruction copyForSSA(SSAInstructionFactory insts, int[] defs, int[] uses) {
        assert (defs == null || defs.length == 1);
        return insts.GetCaughtExceptionInstruction(this.bbNumber, defs == null ? this.exceptionValueNumber : defs[0]);
    }

    public String toString(SymbolTable symbolTable) {
        StringBuffer s = new StringBuffer();
        s.append(this.getValueString(symbolTable, this.exceptionValueNumber)).append(" = getCaughtException ");
        return s.toString();
    }

    public void visit(SSAInstruction.IVisitor v) {
        if (v == null) {
            throw new IllegalArgumentException("v is null");
        }
        v.visitGetCaughtException(this);
    }

    public int getException() {
        return this.exceptionValueNumber;
    }

    public boolean hasDef() {
        return true;
    }

    public int getDef() {
        return this.exceptionValueNumber;
    }

    public int getDef(int i) {
        assert (i == 0);
        return this.exceptionValueNumber;
    }

    public int getNumberOfDefs() {
        return 1;
    }

    public int getBasicBlockNumber() {
        return this.bbNumber;
    }

    public int hashCode() {
        return 2243 * this.exceptionValueNumber;
    }

    public boolean isFallThrough() {
        return true;
    }
}

