/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ssa;

import com.ibm.wala.shrikeBT.IConditionalBranchInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInstructionFactory;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.types.TypeReference;

public class SSAConditionalBranchInstruction
extends SSAInstruction {
    private final IConditionalBranchInstruction.IOperator operator;
    private final int val1;
    private final int val2;
    private final TypeReference type;

    public SSAConditionalBranchInstruction(IConditionalBranchInstruction.IOperator operator, TypeReference type, int val1, int val2) throws IllegalArgumentException {
        this.operator = operator;
        this.val1 = val1;
        this.val2 = val2;
        this.type = type;
        if (val1 <= 0) {
            throw new IllegalArgumentException("Invalid val1: " + val1);
        }
        if (val2 <= 0) {
            throw new IllegalArgumentException("Invalid val2: " + val2);
        }
    }

    public SSAInstruction copyForSSA(SSAInstructionFactory insts, int[] defs, int[] uses) throws IllegalArgumentException {
        if (uses != null && uses.length < 2) {
            throw new IllegalArgumentException("(uses != null) and (uses.length < 2)");
        }
        return insts.ConditionalBranchInstruction(this.operator, this.type, uses == null ? this.val1 : uses[0], uses == null ? this.val2 : uses[1]);
    }

    public IConditionalBranchInstruction.IOperator getOperator() {
        return this.operator;
    }

    public String toString(SymbolTable symbolTable) {
        return "conditional branch(" + this.operator + ") " + this.getValueString(symbolTable, this.val1) + "," + this.getValueString(symbolTable, this.val2);
    }

    public void visit(SSAInstruction.IVisitor v) {
        if (v == null) {
            throw new IllegalArgumentException("v is null");
        }
        v.visitConditionalBranch(this);
    }

    public int getNumberOfUses() {
        return 2;
    }

    public int getUse(int j) {
        assert (j <= 1);
        return j == 0 ? this.val1 : this.val2;
    }

    public TypeReference getType() {
        return this.type;
    }

    public boolean isObjectComparison() {
        return this.type == TypeReference.JavaLangObject;
    }

    public boolean isIntegerComparison() {
        return this.type == TypeReference.Int;
    }

    public int hashCode() {
        return 7151 * this.val1 + this.val2;
    }

    public boolean isFallThrough() {
        return true;
    }
}

