/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ssa;

import com.ibm.wala.shrikeBT.IComparisonInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInstructionFactory;
import com.ibm.wala.ssa.SymbolTable;

public class SSAComparisonInstruction
extends SSAInstruction {
    private final int result;
    private final int val1;
    private final int val2;
    private final IComparisonInstruction.Operator operator;

    public SSAComparisonInstruction(IComparisonInstruction.Operator operator, int result, int val1, int val2) {
        this.operator = operator;
        this.result = result;
        this.val1 = val1;
        this.val2 = val2;
    }

    public SSAInstruction copyForSSA(SSAInstructionFactory insts, int[] defs, int[] uses) throws IllegalArgumentException {
        if (uses != null && uses.length != 2) {
            throw new IllegalArgumentException("expected 2 uses or null, but got " + uses.length);
        }
        return insts.ComparisonInstruction(this.operator, defs == null || defs.length == 0 ? this.result : defs[0], uses == null ? this.val1 : uses[0], uses == null ? this.val2 : uses[1]);
    }

    public String toString(SymbolTable symbolTable) {
        return String.valueOf(this.getValueString(symbolTable, this.result)) + " = compare " + this.getValueString(symbolTable, this.val1) + "," + this.getValueString(symbolTable, this.val2) + " opcode=" + (Object)((Object)this.operator);
    }

    public void visit(SSAInstruction.IVisitor v) throws NullPointerException {
        v.visitComparison(this);
    }

    public boolean hasDef() {
        return true;
    }

    public int getDef() {
        return this.result;
    }

    public int getDef(int i) {
        assert (i == 0);
        return this.result;
    }

    public int getNumberOfDefs() {
        return 1;
    }

    public int getNumberOfUses() {
        return 2;
    }

    public int getUse(int j) {
        assert (j <= 1);
        return j == 0 ? this.val1 : this.val2;
    }

    public int hashCode() {
        return 6311 * this.result ^ 2371 * this.val1 + this.val2;
    }

    public boolean isFallThrough() {
        return true;
    }

    public IComparisonInstruction.Operator getOperator() {
        return this.operator;
    }
}

