/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ssa;

import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInstructionFactory;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.types.TypeReference;

public abstract class SSACheckCastInstruction
extends SSAInstruction {
    private final int result;
    private final int val;
    private final TypeReference[] declaredResultTypes;
    private final boolean isPEI;

    protected SSACheckCastInstruction(int result, int val, TypeReference[] types, boolean isPEI) {
        this.result = result;
        this.val = val;
        this.declaredResultTypes = types;
        this.isPEI = isPEI;
    }

    public SSAInstruction copyForSSA(SSAInstructionFactory insts, int[] defs, int[] uses) {
        if (defs != null && defs.length == 0) {
            throw new IllegalArgumentException("(defs != null) and (defs.length == 0)");
        }
        if (uses != null && uses.length == 0) {
            throw new IllegalArgumentException("(uses != null) and (uses.length == 0)");
        }
        return insts.CheckCastInstruction(defs == null ? this.result : defs[0], uses == null ? this.val : uses[0], this.declaredResultTypes, this.isPEI);
    }

    public String toString(SymbolTable symbolTable) {
        String v = String.valueOf(this.getValueString(symbolTable, this.result)) + " = checkcast";
        TypeReference[] typeReferenceArray = this.declaredResultTypes;
        int n = this.declaredResultTypes.length;
        int n2 = 0;
        while (n2 < n) {
            TypeReference t = typeReferenceArray[n2];
            v = String.valueOf(v) + " " + t;
            ++n2;
        }
        return String.valueOf(v) + this.getValueString(symbolTable, this.val);
    }

    public void visit(SSAInstruction.IVisitor v) {
        if (v == null) {
            throw new IllegalArgumentException("v is null");
        }
        v.visitCheckCast(this);
    }

    public boolean hasDef() {
        return true;
    }

    public int getDef() {
        return this.result;
    }

    public int getDef(int i) {
        assert (i == 0);
        return this.result;
    }

    public int getNumberOfDefs() {
        return 1;
    }

    public int getNumberOfUses() {
        return 1;
    }

    public int getUse(int j) {
        assert (j == 0);
        return this.val;
    }

    @Deprecated
    public TypeReference getDeclaredResultType() {
        assert (this.declaredResultTypes.length == 1);
        return this.declaredResultTypes[0];
    }

    public TypeReference[] getDeclaredResultTypes() {
        return this.declaredResultTypes;
    }

    public int getResult() {
        return this.result;
    }

    public int getVal() {
        return this.val;
    }

    public int hashCode() {
        return this.result * 7529 + this.val;
    }

    public boolean isPEI() {
        return this.isPEI;
    }

    public boolean isFallThrough() {
        return true;
    }

    public String toString() {
        String s = super.toString();
        TypeReference[] typeReferenceArray = this.declaredResultTypes;
        int n = this.declaredResultTypes.length;
        int n2 = 0;
        while (n2 < n) {
            TypeReference t = typeReferenceArray[n2];
            s = String.valueOf(s) + " " + t;
            ++n2;
        }
        return s;
    }
}

