/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ssa;

import com.ibm.wala.shrikeBT.IBinaryOpInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SymbolTable;

public abstract class SSABinaryOpInstruction
extends SSAInstruction {
    private final int result;
    private final int val1;
    private final int val2;
    private final IBinaryOpInstruction.IOperator operator;
    private final boolean mayBeInteger;

    protected SSABinaryOpInstruction(IBinaryOpInstruction.IOperator operator, int result, int val1, int val2, boolean mayBeInteger) {
        this.result = result;
        this.val1 = val1;
        this.val2 = val2;
        this.operator = operator;
        this.mayBeInteger = mayBeInteger;
        if (val1 <= 0) {
            throw new IllegalArgumentException("illegal val1: " + val1);
        }
        if (val2 <= 0) {
            throw new IllegalArgumentException("illegal val2: " + val2);
        }
    }

    public String toString(SymbolTable symbolTable) {
        return String.valueOf(this.getValueString(symbolTable, this.result)) + " = binaryop(" + this.operator + ") " + this.getValueString(symbolTable, this.val1) + " , " + this.getValueString(symbolTable, this.val2);
    }

    public void visit(SSAInstruction.IVisitor v) throws NullPointerException {
        v.visitBinaryOp(this);
    }

    public IBinaryOpInstruction.IOperator getOperator() {
        return this.operator;
    }

    public boolean hasDef() {
        return true;
    }

    public int getDef() {
        return this.result;
    }

    public int getDef(int i) {
        assert (i == 0);
        return this.result;
    }

    public int getNumberOfDefs() {
        return 1;
    }

    public int getNumberOfUses() {
        return 2;
    }

    public int getUse(int j) {
        assert (j <= 1);
        return j == 0 ? this.val1 : this.val2;
    }

    public int hashCode() {
        return 6311 * this.result ^ 2371 * this.val1 + this.val2;
    }

    public boolean isPEI() {
        return this.mayBeInteger && (this.operator == IBinaryOpInstruction.Operator.DIV || this.operator == IBinaryOpInstruction.Operator.REM);
    }

    public boolean isFallThrough() {
        return true;
    }

    public boolean mayBeIntegerOp() {
        return this.mayBeInteger;
    }
}

