/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ssa;

import com.ibm.wala.ssa.SSAArrayReferenceInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInstructionFactory;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.types.TypeReference;

public abstract class SSAArrayStoreInstruction
extends SSAArrayReferenceInstruction {
    private final int value;

    protected SSAArrayStoreInstruction(int arrayref, int index, int value, TypeReference elementType) {
        super(arrayref, index, elementType);
        this.value = value;
    }

    public SSAInstruction copyForSSA(SSAInstructionFactory insts, int[] defs, int[] uses) {
        if (uses != null && uses.length < 3) {
            throw new IllegalArgumentException("uses.length < 3");
        }
        return insts.ArrayStoreInstruction(uses == null ? this.getArrayRef() : uses[0], uses == null ? this.getIndex() : uses[1], uses == null ? this.value : uses[2], this.getElementType());
    }

    public String toString(SymbolTable symbolTable) {
        return "arraystore " + this.getValueString(symbolTable, this.getArrayRef()) + "[" + this.getValueString(symbolTable, this.getIndex()) + "] = " + this.getValueString(symbolTable, this.value);
    }

    public void visit(SSAInstruction.IVisitor v) {
        if (v == null) {
            throw new IllegalArgumentException("v is null");
        }
        v.visitArrayStore(this);
    }

    public int getNumberOfUses() {
        return 3;
    }

    public int getNumberOfDefs() {
        return 0;
    }

    public int getValue() {
        return this.value;
    }

    public int getUse(int j) {
        if (j == 2) {
            return this.value;
        }
        return super.getUse(j);
    }

    public int hashCode() {
        return 6311 * this.value ^ 2371 * this.getArrayRef() + this.getIndex();
    }
}

