/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ssa;

import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInstructionFactory;
import com.ibm.wala.ssa.SymbolTable;

public abstract class SSAArrayLengthInstruction
extends SSAInstruction {
    private final int result;
    private final int arrayref;

    protected SSAArrayLengthInstruction(int result, int arrayref) {
        this.result = result;
        this.arrayref = arrayref;
    }

    public SSAInstruction copyForSSA(SSAInstructionFactory insts, int[] defs, int[] uses) throws IllegalArgumentException {
        if (defs != null && defs.length != 1) {
            throw new IllegalArgumentException();
        }
        if (uses != null && uses.length != 1) {
            throw new IllegalArgumentException();
        }
        return insts.ArrayLengthInstruction(defs == null ? this.result : defs[0], uses == null ? this.arrayref : uses[0]);
    }

    public String toString(SymbolTable symbolTable) {
        return String.valueOf(this.getValueString(symbolTable, this.result)) + " = arraylength " + this.getValueString(symbolTable, this.arrayref);
    }

    public void visit(SSAInstruction.IVisitor v) throws NullPointerException {
        v.visitArrayLength(this);
    }

    public int getDef() {
        return this.result;
    }

    public boolean hasDef() {
        return true;
    }

    public int getDef(int i) {
        if (i != 0) {
            throw new IllegalArgumentException("invalid i " + i);
        }
        return this.result;
    }

    public int getNumberOfDefs() {
        return 1;
    }

    public int getArrayRef() {
        return this.arrayref;
    }

    public int getNumberOfUses() {
        return 1;
    }

    public int getUse(int j) {
        if (j != 0) {
            throw new IllegalArgumentException("invalid j: " + j);
        }
        return this.arrayref;
    }

    public int hashCode() {
        return this.arrayref * 7573 + this.result * 563;
    }

    public boolean isPEI() {
        return true;
    }

    public boolean isFallThrough() {
        return true;
    }
}

