/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ssa;

import com.ibm.wala.ssa.IVisitorWithAddresses;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInstructionFactory;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.types.FieldReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.debug.Assertions;

public class SSAAddressOfInstruction
extends SSAInstruction {
    private final int lval;
    private final int addressVal;
    private final int indexVal;
    private final FieldReference field;
    private final TypeReference pointeeType;

    public SSAAddressOfInstruction(int lval, int local, TypeReference pointeeType) {
        if (local <= 0) {
            throw new IllegalArgumentException("Invalid local address load of " + local);
        }
        this.lval = lval;
        this.addressVal = local;
        this.indexVal = -1;
        this.field = null;
        this.pointeeType = pointeeType;
    }

    public SSAAddressOfInstruction(int lval, int basePointer, int indexVal, TypeReference pointeeType) {
        this.lval = lval;
        this.addressVal = basePointer;
        this.indexVal = indexVal;
        this.field = null;
        this.pointeeType = pointeeType;
    }

    public SSAAddressOfInstruction(int lval, int basePointer, FieldReference field, TypeReference pointeeType) {
        this.lval = lval;
        this.addressVal = basePointer;
        this.indexVal = -1;
        this.field = field;
        this.pointeeType = pointeeType;
    }

    public TypeReference getType() {
        return this.pointeeType;
    }

    public SSAInstruction copyForSSA(SSAInstructionFactory insts, int[] defs, int[] uses) {
        Assertions.UNREACHABLE("not yet implemented.  to be nuked");
        return null;
    }

    public int hashCode() {
        return this.lval * 99701 + this.addressVal;
    }

    public boolean isFallThrough() {
        return true;
    }

    public String toString(SymbolTable symbolTable) {
        return String.valueOf(this.getValueString(symbolTable, this.lval)) + " (" + this.pointeeType.getName() + ") " + " = &" + this.getValueString(symbolTable, this.addressVal) + (this.indexVal != -1 ? "[" + this.getValueString(symbolTable, this.indexVal) + "]" : (this.field != null ? "." + this.field.getName().toString() : ""));
    }

    public void visit(SSAInstruction.IVisitor v) {
        assert (v instanceof IVisitorWithAddresses) : "expected an instance of IVisitorWithAddresses";
        ((IVisitorWithAddresses)v).visitAddressOf(this);
    }

    public int getNumberOfDefs() {
        return 1;
    }

    public int getDef(int i) {
        assert (i == 0);
        return this.lval;
    }

    public int getDef() {
        return this.lval;
    }

    public int getNumberOfUses() {
        return this.indexVal == -1 ? 1 : 2;
    }

    public int getUse(int i) {
        assert (i == 0 || i == 1 && this.indexVal != -1);
        if (i == 0) {
            return this.addressVal;
        }
        return this.indexVal;
    }
}

