/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrikeCT;

import com.ibm.wala.shrikeCT.AttributeReader;
import com.ibm.wala.shrikeCT.ClassReader;
import com.ibm.wala.shrikeCT.InvalidClassFileException;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.Pair;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationsReader
extends AttributeReader {
    private final int beginOffset;

    public AnnotationsReader(ClassReader.AttrIterator iter, String label) throws InvalidClassFileException {
        super(iter, label);
        this.beginOffset = this.attr;
    }

    public int getAnnotationCount() throws InvalidClassFileException {
        int offset = this.beginOffset + 6;
        this.checkSize(offset, 2);
        return this.cr.getUShort(offset);
    }

    public int getAttributeSize() throws InvalidClassFileException {
        int offset = this.beginOffset + 2;
        this.checkSize(offset, 4);
        return this.cr.getInt(offset) + 6;
    }

    private String getUtf8ConstantPoolValue(int offset) throws InvalidClassFileException {
        this.checkSize(offset, 2);
        int cpOffset = this.cr.getUShort(offset);
        return this.cr.getCP().getCPUtf8(cpOffset);
    }

    public AnnotationAttribute[] getAllAnnotations() throws InvalidClassFileException {
        AnnotationAttribute[] result = new AnnotationAttribute[this.getAnnotationCount()];
        int offset = this.beginOffset + 8;
        int i = 0;
        while (i < result.length) {
            Pair<AnnotationAttribute, Integer> attributeAndSize = this.getAttributeAndSize(offset);
            result[i] = (AnnotationAttribute)attributeAndSize.fst;
            offset += ((Integer)attributeAndSize.snd).intValue();
            ++i;
        }
        return result;
    }

    private Pair<AnnotationAttribute, Integer> getAttributeAndSize(int begin) throws InvalidClassFileException {
        String type = this.getUtf8ConstantPoolValue(begin);
        int numElementValuePairs = this.cr.getUShort(begin + 2);
        int size = 4;
        int offset = begin + 4;
        HashMap<String, ElementValue> elementName2Val = HashMapFactory.make();
        int i = 0;
        while (i < numElementValuePairs) {
            String elementName = this.getUtf8ConstantPoolValue(offset);
            Pair<ElementValue, Integer> elementValAndSize = this.readElementValueAndSize(offset += 2);
            offset += ((Integer)elementValAndSize.snd).intValue();
            size += (Integer)elementValAndSize.snd + 2;
            elementName2Val.put(elementName, (ElementValue)elementValAndSize.fst);
            ++i;
        }
        return Pair.make(new AnnotationAttribute(type, elementName2Val), size);
    }

    private Pair<ElementValue, Integer> readElementValueAndSize(int offset) throws IllegalArgumentException, InvalidClassFileException {
        char tag = (char)this.cr.getByte(offset);
        int nextShort = this.cr.getUShort(offset + 1);
        switch (tag) {
            case 'B': 
            case 'C': 
            case 'I': 
            case 'S': 
            case 'Z': {
                return Pair.make(new ConstantElementValue(this.cr.getCP().getCPInt(nextShort)), 3);
            }
            case 'J': {
                return Pair.make(new ConstantElementValue(this.cr.getCP().getCPLong(nextShort)), 3);
            }
            case 'D': {
                return Pair.make(new ConstantElementValue(this.cr.getCP().getCPDouble(nextShort)), 3);
            }
            case 'F': {
                return Pair.make(new ConstantElementValue(Float.valueOf(this.cr.getCP().getCPFloat(nextShort))), 3);
            }
            case 'c': 
            case 's': {
                return Pair.make(new ConstantElementValue(this.cr.getCP().getCPUtf8(nextShort)), 3);
            }
            case 'e': {
                return Pair.make(new EnumElementValue(this.cr.getCP().getCPUtf8(nextShort), this.cr.getCP().getCPUtf8(this.cr.getUShort(offset + 3))), 5);
            }
            case '[': {
                int numValues = nextShort;
                int numArrayBytes = 3;
                ElementValue[] vals = new ElementValue[numValues];
                int curArrayOffset = offset + 3;
                int i = 0;
                while (i < numValues) {
                    Pair<ElementValue, Integer> arrayElemValueAndSize = this.readElementValueAndSize(curArrayOffset);
                    vals[i] = (ElementValue)arrayElemValueAndSize.fst;
                    curArrayOffset += ((Integer)arrayElemValueAndSize.snd).intValue();
                    numArrayBytes += ((Integer)arrayElemValueAndSize.snd).intValue();
                    ++i;
                }
                return Pair.make(new ArrayElementValue(vals), numArrayBytes);
            }
            case '@': {
                Pair<AnnotationAttribute, Integer> attributeAndSize = this.getAttributeAndSize(offset + 1);
                return Pair.make((ElementValue)attributeAndSize.fst, (Integer)attributeAndSize.snd + 1);
            }
        }
        assert (false);
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AnnotationAttribute
    implements ElementValue {
        public final String type;
        public final Map<String, ElementValue> elementValues;

        public AnnotationAttribute(String type, Map<String, ElementValue> elementValues) {
            this.type = type;
            this.elementValues = elementValues;
        }

        public String toString() {
            return "AnnotationElementValue [type=" + this.type + ", elementValues=" + this.elementValues + "]";
        }
    }

    public static class ArrayElementValue
    implements ElementValue {
        public final ElementValue[] vals;

        public ArrayElementValue(ElementValue[] vals) {
            this.vals = vals;
        }

        public String toString() {
            return "ArrayElementValue [vals=" + Arrays.toString(this.vals) + "]";
        }
    }

    public static class ConstantElementValue
    implements ElementValue {
        public final Object val;

        public ConstantElementValue(Object val) {
            this.val = val;
        }

        public String toString() {
            return this.val.toString();
        }
    }

    public static interface ElementValue {
    }

    public static class EnumElementValue
    implements ElementValue {
        public final String enumType;
        public final String enumVal;

        public EnumElementValue(String enumType, String enumVal) {
            this.enumType = enumType;
            this.enumVal = enumVal;
        }

        public String toString() {
            return "EnumElementValue [type=" + this.enumType + ", val=" + this.enumVal + "]";
        }
    }
}

