/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrikeBT;

import com.ibm.wala.shrikeBT.GetInstruction;
import com.ibm.wala.shrikeBT.IInvokeInstruction;
import com.ibm.wala.shrikeBT.InvokeInstruction;
import com.ibm.wala.shrikeBT.PutInstruction;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Util {
    private static final HashMap<String, String> classAliases;
    private static final HashMap<String, String> typeAliases;
    private static final byte[] typeIndices;

    static {
        typeAliases = new HashMap();
        classAliases = new HashMap();
        Util.addAlias("void", "V");
        Util.addAlias("int", "I");
        Util.addAlias("long", "J");
        Util.addAlias("float", "F");
        Util.addAlias("double", "D");
        Util.addAlias("byte", "B");
        Util.addAlias("char", "C");
        Util.addAlias("short", "S");
        Util.addAlias("boolean", "Z");
        typeIndices = Util.makeTypeIndices();
    }

    private Util() {
    }

    public static byte getWordSize(String s) {
        if (s == null || s.length() == 0) {
            throw new IllegalArgumentException("invalid s: " + s);
        }
        return Util.getWordSize(s, 0);
    }

    static byte getWordSize(String s, int index) {
        switch (s.charAt(index)) {
            case 'V': {
                return 0;
            }
            case 'D': 
            case 'J': {
                return 2;
            }
        }
        return 1;
    }

    private static int getTypeLength(String s, int i) {
        switch (s.charAt(i)) {
            case 'L': {
                return s.indexOf(59, i) - i + 1;
            }
            case '[': {
                return Util.getTypeLength(s, i + 1) + 1;
            }
        }
        return 1;
    }

    /*
     * Unable to fully structure code
     */
    public static int getParamsWordSize(String type) throws IllegalArgumentException {
        if (type == null) {
            throw new IllegalArgumentException("type is null");
        }
        index = 1;
        count = 0;
        if (type.indexOf(41, 1) >= 0) ** GOTO lbl9
        throw new IllegalArgumentException("Invalid method descriptor (missing ')'): " + type);
lbl-1000:
        // 1 sources

        {
            count += Util.getWordSize(type, index);
            index += Util.getTypeLength(type, index);
lbl9:
            // 2 sources

            ** while (type.charAt((int)index) != ')')
        }
lbl10:
        // 1 sources

        return count;
    }

    public static String makeType(String c) {
        if (c == null) {
            throw new IllegalArgumentException("c is null");
        }
        if (c.startsWith("[")) {
            return c.replace('.', '/');
        }
        if (!c.endsWith(";")) {
            return "L" + c.replace('.', '/') + ";";
        }
        return c;
    }

    public static String makeTypeAll(String c) {
        String alias = typeAliases.get(c);
        if (alias != null) {
            return alias;
        }
        return Util.makeType(c);
    }

    public static String makeClass(String t) throws IllegalArgumentException {
        if (t == null) {
            throw new IllegalArgumentException("t is null");
        }
        if (t.startsWith("[")) {
            return t;
        }
        if (!t.startsWith("L")) {
            throw new IllegalArgumentException(String.valueOf(t) + " is not a valid class type");
        }
        return t.substring(1, t.length() - 1).replace('/', '.');
    }

    static String makeClassAll(String t) {
        String alias = classAliases.get(t);
        if (alias != null) {
            return alias;
        }
        return Util.makeClass(t);
    }

    private static void addAlias(String c, String t) {
        typeAliases.put(c, t);
        classAliases.put(t, c);
    }

    public static String makeType(Class<?> c) {
        if (c == null) {
            throw new IllegalArgumentException("c is null");
        }
        String name = c.getName();
        String alias = typeAliases.get(name);
        if (alias != null) {
            return alias;
        }
        return Util.makeType(name);
    }

    static int getParamsCount(String type) throws IllegalArgumentException {
        if (type == null || type.length() < 2) {
            throw new IllegalArgumentException("invalid type: " + type);
        }
        int index = 1;
        int count = 0;
        try {
            while (type.charAt(index) != ')') {
                ++count;
                index += Util.getTypeLength(type, index);
            }
            return count;
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new IllegalArgumentException("invalid type: " + type);
        }
    }

    public static String[] getParamsTypes(String thisClassType, String type) throws IllegalArgumentException {
        if (type == null) {
            throw new IllegalArgumentException("type == null");
        }
        int count = thisClassType != null ? 1 : 0;
        String[] r = new String[Util.getParamsCount(type) + count];
        int index = 1;
        if (thisClassType != null) {
            r[0] = thisClassType;
        }
        while (type.charAt(index) != ')') {
            int len = Util.getTypeLength(type, index);
            r[count] = type.substring(index, index + len);
            ++count;
            index += len;
        }
        return r;
    }

    public static String[] getParamsTypesInLocals(String thisClassType, String type) throws IllegalArgumentException {
        if (type == null) {
            throw new IllegalArgumentException("type == null");
        }
        int count = thisClassType != null ? 1 : 0;
        String[] r = new String[Util.getParamsWordSize(type) + count];
        int index = 1;
        if (thisClassType != null) {
            r[0] = thisClassType;
        }
        while (type.charAt(index) != ')') {
            String t;
            int len = Util.getTypeLength(type, index);
            r[count] = t = Util.getStackType(type.substring(index, index + len));
            count += Util.getWordSize(t);
            index += len;
        }
        return r;
    }

    public static String getStackType(String t) {
        if (t == null || t.length() < 1) {
            throw new IllegalArgumentException("invalid t: " + t);
        }
        switch (t.charAt(0)) {
            case 'B': 
            case 'C': 
            case 'S': 
            case 'Z': {
                return "I";
            }
        }
        return t;
    }

    public static String makeArray(String t) {
        return ("[" + t).intern();
    }

    public static boolean isArrayType(String t) {
        if (t == null || t.length() == 0) {
            return false;
        }
        switch (t.charAt(0)) {
            case '[': {
                return true;
            }
        }
        return false;
    }

    public static boolean isPrimitiveType(String t) {
        if (t == null || t.length() == 0) {
            return false;
        }
        switch (t.charAt(0)) {
            case 'L': 
            case '[': {
                return false;
            }
        }
        return true;
    }

    public static String getReturnType(String s) {
        if (s == null) {
            throw new IllegalArgumentException("s is null");
        }
        return s.substring(s.lastIndexOf(41) + 1);
    }

    public static void error(String s) {
        System.err.println(s);
        new Error("Stack Trace").printStackTrace();
    }

    public static String computeSignature(Class<?>[] params, Class<?> result) throws IllegalArgumentException {
        if (params == null) {
            throw new IllegalArgumentException("params == null");
        }
        StringBuffer buf = new StringBuffer();
        buf.append("(");
        int i = 0;
        while (i < params.length) {
            buf.append(Util.makeType(params[i]));
            ++i;
        }
        buf.append(")");
        buf.append(Util.makeType(result));
        return buf.toString();
    }

    public static GetInstruction makeGet(Class<?> c, String name) {
        if (c == null) {
            throw new IllegalArgumentException("c is null");
        }
        try {
            Field f = c.getField(name);
            return GetInstruction.make(Util.makeType(f.getType()), Util.makeType(c), name, (f.getModifiers() & 8) != 0);
        }
        catch (SecurityException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        catch (NoSuchFieldException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public static PutInstruction makePut(Class<?> c, String name) {
        if (c == null) {
            throw new IllegalArgumentException("c is null");
        }
        try {
            Field f = c.getField(name);
            return PutInstruction.make(Util.makeType(f.getType()), Util.makeType(c), name, (f.getModifiers() & 8) != 0);
        }
        catch (SecurityException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        catch (NoSuchFieldException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    private static String makeName(String name, Class<?>[] paramTypes) {
        if (paramTypes == null) {
            return name;
        }
        StringBuffer buf = new StringBuffer(name);
        buf.append("(");
        int i = 0;
        while (i < paramTypes.length) {
            if (i > 0) {
                buf.append(",");
            }
            buf.append(paramTypes[i].getName());
            ++i;
        }
        buf.append(")");
        return buf.toString();
    }

    public static Method findMethod(Class<?> c, String name) {
        return Util.findMethod(c, name, null);
    }

    public static Method findMethod(Class<?> c, String name, Class<?>[] paramTypes) {
        if (c == null) {
            throw new IllegalArgumentException("c is null");
        }
        Method[] methods = c.getMethods();
        Method result = null;
        int i = 0;
        while (i < methods.length) {
            Method m = methods[i];
            if (m.getName().equals(name) && (paramTypes == null || Arrays.equals(m.getParameterTypes(), paramTypes))) {
                if (result != null) {
                    throw new IllegalArgumentException("Method " + Util.makeName(name, paramTypes) + " is ambiguous in class " + c);
                }
                result = m;
            }
            ++i;
        }
        return result;
    }

    public static InvokeInstruction makeInvoke(Class<?> c, String name, Class<?>[] paramTypes) {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        InvokeInstruction result = null;
        if (name.equals("<init>")) {
            Constructor<?>[] cs = c.getConstructors();
            int i = 0;
            while (i < cs.length) {
                Constructor<?> con = cs[i];
                if (paramTypes == null || Arrays.equals(con.getParameterTypes(), paramTypes)) {
                    if (result != null) {
                        throw new IllegalArgumentException("Constructor " + Util.makeName(name, paramTypes) + " is ambiguous in class " + c);
                    }
                    result = InvokeInstruction.make(Util.computeSignature(con.getParameterTypes(), Void.TYPE), Util.makeType(c), name, IInvokeInstruction.Dispatch.SPECIAL);
                }
                ++i;
            }
        } else {
            Method m = Util.findMethod(c, name, paramTypes);
            if (m != null) {
                IInvokeInstruction.Dispatch opcode = IInvokeInstruction.Dispatch.VIRTUAL;
                if ((m.getModifiers() & 8) != 0) {
                    opcode = IInvokeInstruction.Dispatch.STATIC;
                } else if (m.getDeclaringClass().isInterface()) {
                    opcode = IInvokeInstruction.Dispatch.INTERFACE;
                }
                result = InvokeInstruction.make(Util.computeSignature(m.getParameterTypes(), m.getReturnType()), Util.makeType(c), name, opcode);
            }
        }
        if (result == null) {
            throw new IllegalArgumentException("Method " + Util.makeName(name, paramTypes) + " is not present in class " + c);
        }
        return result;
    }

    public static InvokeInstruction makeInvoke(Class<?> c, String name) {
        return Util.makeInvoke(c, name, null);
    }

    static int getTypeIndex(String t) {
        if (t == null) {
            return -1;
        }
        int len = t.length();
        if (len < 1) {
            return -1;
        }
        char ch = t.charAt(0);
        if (ch < typeIndices.length) {
            byte r = typeIndices[ch];
            if (r != 4) {
                if (len > 1) {
                    return -1;
                }
                return r;
            }
            return r;
        }
        return -1;
    }

    private static byte[] makeTypeIndices() {
        byte[] r = new byte[128];
        int i = 0;
        while (i < r.length) {
            r[i] = -1;
            ++i;
        }
        r[73] = 0;
        r[74] = 1;
        r[70] = 2;
        r[68] = 3;
        r[76] = 4;
        r[91] = 4;
        r[66] = 5;
        r[67] = 6;
        r[83] = 7;
        r[90] = 8;
        return r;
    }

    public static void readFully(InputStream s, byte[] bytes) throws IllegalArgumentException, IllegalArgumentException, IOException {
        if (s == null) {
            throw new IllegalArgumentException("s == null");
        }
        if (bytes == null) {
            throw new IllegalArgumentException("bytes == null");
        }
        int offset = 0;
        while (offset < bytes.length) {
            int r = s.read(bytes, offset, bytes.length - offset);
            if (r < 0) {
                throw new IOException("Class truncated");
            }
            offset += r;
        }
    }

    public static byte[] readFully(InputStream s) throws IOException {
        if (s == null) {
            throw new IllegalArgumentException("s is null");
        }
        byte[] bytes = new byte[s.available()];
        Util.readFully(s, bytes);
        int b = s.read();
        if (b < 0) {
            return bytes;
        }
        byte[] big = new byte[bytes.length * 2 + 1];
        System.arraycopy(bytes, 0, big, 0, bytes.length);
        big[bytes.length] = (byte)b;
        int offset = bytes.length + 1;
        while (true) {
            int r;
            if (big.length == offset) {
                bytes = new byte[offset * 2];
                System.arraycopy(big, 0, bytes, 0, offset);
                big = bytes;
            }
            if ((r = s.read(big, offset, big.length - offset)) < 0) {
                bytes = new byte[offset];
                System.arraycopy(big, 0, bytes, 0, offset);
                return bytes;
            }
            offset += r;
        }
    }
}

