/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrikeBT;

import com.ibm.wala.shrikeBT.IInstruction;
import com.ibm.wala.shrikeBT.Instruction;

public final class GotoInstruction
extends Instruction {
    private final int[] label;
    private static final GotoInstruction[] preallocated = GotoInstruction.preallocate();

    protected GotoInstruction(int label) {
        super((short)167);
        int[] l = new int[]{label};
        this.label = l;
    }

    private static GotoInstruction[] preallocate() {
        GotoInstruction[] r = new GotoInstruction[256];
        int i = 0;
        while (i < r.length) {
            r[i] = new GotoInstruction(i);
            ++i;
        }
        return r;
    }

    public static GotoInstruction make(int label) {
        if (label >= 0 && label < preallocated.length) {
            return preallocated[label];
        }
        return new GotoInstruction(label);
    }

    public boolean isFallThrough() {
        return false;
    }

    public int[] getBranchTargets() {
        return this.label;
    }

    public int getLabel() {
        return this.label[0];
    }

    public IInstruction redirectTargets(int[] targetMap) throws IllegalArgumentException {
        if (targetMap == null) {
            throw new IllegalArgumentException("targetMap is null");
        }
        try {
            return GotoInstruction.make(targetMap[this.label[0]]);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Illegal target map", e);
        }
    }

    public boolean equals(Object o) {
        if (o instanceof GotoInstruction) {
            GotoInstruction i = (GotoInstruction)o;
            return i.label == this.label;
        }
        return false;
    }

    public int hashCode() {
        return this.label[0] * 1348091 + 18301;
    }

    public String toString() {
        return "Goto(" + this.getLabel() + ")";
    }

    public void visit(IInstruction.Visitor v) throws IllegalArgumentException {
        if (v == null) {
            throw new IllegalArgumentException();
        }
        v.visitGoto(this);
    }

    public boolean isPEI() {
        return false;
    }
}

