/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrike.bench;

import com.ibm.wala.shrikeBT.IInstruction;
import com.ibm.wala.shrikeBT.InvokeInstruction;
import com.ibm.wala.shrikeBT.MethodData;
import com.ibm.wala.shrikeBT.Util;
import com.ibm.wala.shrikeBT.shrikeCT.ClassInstrumenter;
import com.ibm.wala.shrikeBT.shrikeCT.OfflineInstrumenter;
import com.ibm.wala.shrikeCT.ClassReader;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.Writer;

public class Statistics {
    private static OfflineInstrumenter instrumenter;

    public static void main(String[] args) throws Exception {
        int i = 0;
        while (i < 1) {
            ClassInstrumenter ci;
            instrumenter = new OfflineInstrumenter();
            BufferedWriter w = new BufferedWriter(new FileWriter("report", false));
            args = instrumenter.parseStandardArgs(args);
            instrumenter.beginTraversal();
            while ((ci = instrumenter.nextClass()) != null) {
                Statistics.doClass(ci, w);
            }
            instrumenter.close();
            ((Writer)w).close();
            ++i;
        }
    }

    private static void doClass(ClassInstrumenter ci, Writer w) throws Exception {
        ClassReader cr = ci.getReader();
        String className = cr.getName();
        w.write("Class: " + className + "\n");
        boolean allPrivateConstructors = true;
        boolean methodCallsConstructor = false;
        boolean classInitCallsConstructor = false;
        int m = 0;
        while (m < cr.getMethodCount()) {
            MethodData d = ci.visitMethod(m);
            if (d != null) {
                int f;
                if (d.getName().equals("<init>") && ((f = cr.getMethodAccessFlags(m)) & 2) == 0 && ((f & 4) == 0 || (cr.getAccessFlags() & 0x10) == 0)) {
                    allPrivateConstructors = false;
                }
                int constructorCalls = 0;
                IInstruction[] instrs = d.getInstructions();
                int i = 0;
                while (i < instrs.length) {
                    InvokeInstruction invoke;
                    if (instrs[i] instanceof InvokeInstruction && (invoke = (InvokeInstruction)instrs[i]).getMethodName().equals("<init>") && invoke.getClassType().equals(Util.makeType(className))) {
                        ++constructorCalls;
                    }
                    ++i;
                }
                if (!d.getName().equals("<init>") && !d.getName().equals("<clinit>")) {
                    if (constructorCalls > 0) {
                        methodCallsConstructor = true;
                    }
                } else if (d.getName().equals("<clinit>")) {
                    classInitCallsConstructor = true;
                }
            }
            ++m;
        }
        if (allPrivateConstructors && !methodCallsConstructor && classInitCallsConstructor) {
            w.write("Restricted Creation\n");
        }
    }
}

