/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.summaries;

import com.ibm.wala.cfg.AbstractCFG;
import com.ibm.wala.cfg.InducedCFG;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.Context;
import com.ibm.wala.ssa.ConstantValue;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSACFG;
import com.ibm.wala.ssa.SSAIndirectionData;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAOptions;
import com.ibm.wala.ssa.SSAPhiInstruction;
import com.ibm.wala.ssa.SSAPiInstruction;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.util.debug.Assertions;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SyntheticIR
extends IR {
    private static final boolean PARANOID = true;

    public SyntheticIR(IMethod method, Context context, AbstractCFG cfg, SSAInstruction[] instructions, SSAOptions options, Map<Integer, ConstantValue> constants) throws AssertionError {
        super(method, instructions, SyntheticIR.makeSymbolTable(method, instructions, constants, cfg), new SSACFG(method, cfg, instructions), options);
        this.repOK(instructions);
        this.setupLocationMap();
    }

    private void repOK(SSAInstruction[] instructions) {
        SSAInstruction[] sSAInstructionArray = instructions;
        int n = instructions.length;
        int n2 = 0;
        while (n2 < n) {
            SSAInstruction s = sSAInstructionArray[n2];
            if (s instanceof SSAPhiInstruction) {
                Assertions.UNREACHABLE();
            }
            if (s instanceof SSAPiInstruction) {
                Assertions.UNREACHABLE();
            }
            ++n2;
        }
    }

    private static SymbolTable makeSymbolTable(IMethod method, SSAInstruction[] instructions, Map<Integer, ConstantValue> constants, AbstractCFG cfg) {
        if (method == null) {
            throw new IllegalArgumentException("null method");
        }
        SymbolTable symbolTable = new SymbolTable(method.getNumberOfParameters());
        int i = 0;
        while (i < instructions.length) {
            if (instructions[i] != null) {
                SSAInstruction s = instructions[i];
                SyntheticIR.updateForInstruction(constants, symbolTable, s);
            }
            ++i;
        }
        if (cfg instanceof InducedCFG) {
            InducedCFG icfg = (InducedCFG)cfg;
            for (SSAPhiInstruction phi : icfg.getAllPhiInstructions()) {
                SyntheticIR.updateForInstruction(constants, symbolTable, phi);
            }
        }
        return symbolTable;
    }

    private static void updateForInstruction(Map<Integer, ConstantValue> constants, SymbolTable symbolTable, SSAInstruction s) {
        int j = 0;
        while (j < s.getNumberOfDefs()) {
            symbolTable.ensureSymbol(s.getDef(j));
            ++j;
        }
        j = 0;
        while (j < s.getNumberOfUses()) {
            int vn = s.getUse(j);
            symbolTable.ensureSymbol(vn);
            if (constants != null && constants.containsKey(new Integer(vn))) {
                symbolTable.setConstantValue(vn, constants.get(new Integer(vn)));
            }
            ++j;
        }
    }

    @Override
    protected String instructionPosition(int instructionIndex) {
        return "";
    }

    @Override
    public IR.SSA2LocalMap getLocalMap() {
        return null;
    }

    protected SSAIndirectionData<SSAIndirectionData.Name> getIndirectionData() {
        return null;
    }
}

