/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.slicer;

import com.ibm.wala.dataflow.IFDS.BackwardsSupergraph;
import com.ibm.wala.dataflow.IFDS.IMergeFunction;
import com.ibm.wala.dataflow.IFDS.IPartiallyBalancedFlowFunctions;
import com.ibm.wala.dataflow.IFDS.ISupergraph;
import com.ibm.wala.dataflow.IFDS.PartiallyBalancedTabulationProblem;
import com.ibm.wala.dataflow.IFDS.PartiallyBalancedTabulationSolver;
import com.ibm.wala.dataflow.IFDS.PathEdge;
import com.ibm.wala.dataflow.IFDS.TabulationDomain;
import com.ibm.wala.dataflow.IFDS.TabulationResult;
import com.ibm.wala.dataflow.IFDS.UnorderedDomain;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.propagation.PointerAnalysis;
import com.ibm.wala.ipa.modref.ModRef;
import com.ibm.wala.ipa.slicer.ISDG;
import com.ibm.wala.ipa.slicer.MethodEntryStatement;
import com.ibm.wala.ipa.slicer.MethodExitStatement;
import com.ibm.wala.ipa.slicer.PDG;
import com.ibm.wala.ipa.slicer.SDG;
import com.ibm.wala.ipa.slicer.SDGSupergraph;
import com.ibm.wala.ipa.slicer.SliceFunctions;
import com.ibm.wala.ipa.slicer.Statement;
import com.ibm.wala.util.CancelException;
import com.ibm.wala.util.collections.HashSetFactory;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Slicer {
    public static final boolean DEBUG = false;
    public static final boolean VERBOSE = false;

    public static Collection<Statement> computeBackwardSlice(Statement s, CallGraph cg, PointerAnalysis pa, DataDependenceOptions dOptions, ControlDependenceOptions cOptions) throws IllegalArgumentException, CancelException {
        return Slicer.computeSlice(new SDG(cg, pa, ModRef.make(), dOptions, cOptions), Collections.singleton(s), true);
    }

    public static Collection<Statement> computeForwardSlice(Statement s, CallGraph cg, PointerAnalysis pa, DataDependenceOptions dOptions, ControlDependenceOptions cOptions) throws IllegalArgumentException, CancelException {
        return Slicer.computeSlice(new SDG(cg, pa, ModRef.make(), dOptions, cOptions), Collections.singleton(s), false);
    }

    public static Collection<Statement> computeBackwardSlice(SDG sdg, Statement s) throws IllegalArgumentException, CancelException {
        return Slicer.computeSlice(sdg, Collections.singleton(s), true);
    }

    public static Collection<Statement> computeForwardSlice(SDG sdg, Statement s) throws IllegalArgumentException, CancelException {
        return Slicer.computeSlice(sdg, Collections.singleton(s), false);
    }

    public static Collection<Statement> computeBackwardSlice(SDG sdg, Collection<Statement> ss) throws IllegalArgumentException, CancelException {
        return Slicer.computeSlice(sdg, ss, true);
    }

    protected static Collection<Statement> computeSlice(SDG sdg, Collection<Statement> ss, boolean backward) throws CancelException {
        if (sdg == null) {
            throw new IllegalArgumentException("sdg cannot be null");
        }
        return new Slicer().slice(sdg, ss, backward);
    }

    public Collection<Statement> slice(SDG sdg, Collection<Statement> roots, boolean backward) throws CancelException {
        if (sdg == null) {
            throw new IllegalArgumentException("sdg cannot be null");
        }
        SliceProblem p = this.makeSliceProblem(roots, sdg, backward);
        PartiallyBalancedTabulationSolver<Statement, PDG, Object> solver = PartiallyBalancedTabulationSolver.createPartiallyBalancedTabulationSolver(p, null);
        TabulationResult tr = solver.solve();
        Collection<Statement> slice = tr.getSupergraphNodesReached();
        return slice;
    }

    protected SliceProblem makeSliceProblem(Collection<Statement> roots, ISDG sdgView, boolean backward) {
        return new SliceProblem(roots, sdgView, backward);
    }

    public static Collection<Statement> computeBackwardSlice(Statement s, CallGraph cg, PointerAnalysis pointerAnalysis) throws IllegalArgumentException, CancelException {
        return Slicer.computeBackwardSlice(s, cg, pointerAnalysis, DataDependenceOptions.FULL, ControlDependenceOptions.FULL);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ControlDependenceOptions {
        FULL("full"),
        NONE("none"),
        NO_EXCEPTIONAL_EDGES("no_exceptional_edges");

        private final String name;

        private ControlDependenceOptions(String name) {
            this.name = name;
        }

        public final String getName() {
            return this.name;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DataDependenceOptions {
        FULL("full", false, false, false, false),
        NO_BASE_PTRS("no_base_ptrs", true, false, false, false),
        NO_BASE_NO_HEAP("no_base_no_heap", true, true, false, false),
        NO_BASE_NO_EXCEPTIONS("no_base_no_exceptions", true, false, false, true),
        NO_BASE_NO_HEAP_NO_EXCEPTIONS("no_base_no_heap_no_exceptions", true, true, false, true),
        NO_HEAP("no_heap", false, true, false, false),
        NO_HEAP_NO_EXCEPTIONS("no_heap_no_exceptions", false, true, false, true),
        NO_EXCEPTIONS("no_exceptions", false, false, false, true),
        NONE("none", true, true, true, true),
        REFLECTION("no_base_no_heap_no_cast", true, true, true, true);

        private final String name;
        private final boolean ignoreBasePtrs;
        private final boolean ignoreHeap;
        private final boolean terminateAtCast;
        private final boolean ignoreExceptions;

        private DataDependenceOptions(String name, boolean ignoreBasePtrs, boolean ignoreHeap, boolean terminateAtCast, boolean ignoreExceptions) {
            this.name = name;
            this.ignoreBasePtrs = ignoreBasePtrs;
            this.ignoreHeap = ignoreHeap;
            this.terminateAtCast = terminateAtCast;
            this.ignoreExceptions = ignoreExceptions;
        }

        public final boolean isIgnoreBasePtrs() {
            return this.ignoreBasePtrs;
        }

        public final boolean isIgnoreHeap() {
            return this.ignoreHeap;
        }

        public final boolean isIgnoreExceptions() {
            return this.ignoreExceptions;
        }

        public final boolean isTerminateAtCast() {
            return this.terminateAtCast;
        }

        public final String getName() {
            return this.name;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SliceProblem
    implements PartiallyBalancedTabulationProblem<Statement, PDG, Object> {
        private final Collection<Statement> roots;
        private final ISupergraph<Statement, PDG> supergraph;
        private final SliceFunctions f;
        private final boolean backward;

        public SliceProblem(Collection<Statement> roots, ISDG sdg, boolean backward) {
            this.roots = roots;
            this.backward = backward;
            SDGSupergraph forwards = new SDGSupergraph(sdg, backward);
            this.supergraph = backward ? BackwardsSupergraph.make(forwards) : forwards;
            this.f = new SliceFunctions();
        }

        @Override
        public TabulationDomain<Object, Statement> getDomain() {
            return new UnorderedDomain<Object, Statement>();
        }

        @Override
        public IPartiallyBalancedFlowFunctions<Statement> getFunctionMap() {
            return this.f;
        }

        @Override
        public IMergeFunction getMergeFunction() {
            return null;
        }

        @Override
        public ISupergraph<Statement, PDG> getSupergraph() {
            return this.supergraph;
        }

        @Override
        public Collection<PathEdge<Statement>> initialSeeds() {
            if (this.backward) {
                HashSet<PathEdge<Statement>> result = HashSetFactory.make();
                for (Statement st : this.roots) {
                    PathEdge<Statement> seed = PathEdge.createPathEdge(new MethodExitStatement(st.getNode()), 0, st, 0);
                    result.add(seed);
                }
                return result;
            }
            HashSet<PathEdge<Statement>> result = HashSetFactory.make();
            for (Statement st : this.roots) {
                PathEdge<Statement> seed = PathEdge.createPathEdge(new MethodEntryStatement(st.getNode()), 0, st, 0);
                result.add(seed);
            }
            return result;
        }

        @Override
        public Statement getFakeEntry(Statement node) {
            return this.backward ? new MethodExitStatement(node.getNode()) : new MethodEntryStatement(node.getNode());
        }
    }
}

